/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.mware.ge.util.GeLogger;
import com.mware.ge.util.GeLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

public class JavaSerializableUtils {
    private static final GeLogger LOGGER = GeLoggerFactory.getLogger(JavaSerializableUtils.class);

    public static byte[] objectToBytes(Object obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object bytesToObject(byte[] bytes) {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = ois.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.warn("Could not deserialize graph metadata: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    public static <T> T copy(T value) {
        return (T)JavaSerializableUtils.bytesToObject(JavaSerializableUtils.objectToBytes(value));
    }

    private static class DecompressibleInputStream
    extends ObjectInputStream {
        public DecompressibleInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            Class<?> localClass;
            ObjectStreamClass resultClassDescriptor = super.readClassDescriptor();
            try {
                localClass = Class.forName(resultClassDescriptor.getName());
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("No local class for " + resultClassDescriptor.getName(), e);
                return resultClassDescriptor;
            }
            ObjectStreamClass localClassDescriptor = ObjectStreamClass.lookup(localClass);
            if (localClassDescriptor != null) {
                long localSUID = localClassDescriptor.getSerialVersionUID();
                long streamSUID = resultClassDescriptor.getSerialVersionUID();
                if (streamSUID != localSUID) {
                    StringBuffer s = new StringBuffer("Overriding serialized class version mismatch: ");
                    s.append("local serialVersionUID = ").append(localSUID);
                    s.append(" stream serialVersionUID = ").append(streamSUID);
                    LOGGER.debug("Potentially Fatal Deserialization Operation: " + s.toString(), new Object[0]);
                    resultClassDescriptor = localClassDescriptor;
                }
            }
            return resultClassDescriptor;
        }
    }
}

