/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.mware.ge.util.CloseableIterable;
import com.mware.ge.util.CloseableIterator;
import com.mware.ge.util.CloseableUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class LookAheadIterable<TSource, TDest>
implements CloseableIterable<TDest> {
    private boolean doneCalled;

    @Override
    public Iterator<TDest> iterator() {
        final Iterator<TSource> it = this.createIterator();
        return new CloseableIterator<TDest>(){
            private TDest next;
            private TDest current;

            @Override
            public boolean hasNext() {
                this.loadNext();
                if (this.next == null) {
                    this.close();
                }
                return this.next != null;
            }

            @Override
            public TDest next() {
                this.loadNext();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.current = this.next;
                this.next = null;
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                CloseableUtils.closeQuietly(it);
                LookAheadIterable.this.callClose();
            }

            private void loadNext() {
                if (this.next != null) {
                    return;
                }
                while (it.hasNext()) {
                    Object obj;
                    Object n = it.next();
                    if (!LookAheadIterable.this.isIncluded(n, obj = LookAheadIterable.this.convert(n))) continue;
                    this.next = obj;
                    break;
                }
            }
        };
    }

    private void callClose() {
        if (!this.doneCalled) {
            this.doneCalled = true;
            this.close();
        }
    }

    @Override
    public void close() {
    }

    protected abstract boolean isIncluded(TSource var1, TDest var2);

    protected abstract TDest convert(TSource var1);

    protected abstract Iterator<TSource> createIterator();
}

