/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.mware.ge.values.AnyValues;
import com.mware.ge.values.storable.StreamingPropertyValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;

public class ObjectUtils {
    public static boolean equals(Object leftObj, Object rightObj) {
        return ObjectUtils.compare(leftObj, rightObj) == 0;
    }

    public static int compare(Object first, Object second) {
        if (first == null && second == null) {
            return 0;
        }
        if (first == null) {
            return 1;
        }
        if (second == null) {
            return -1;
        }
        if (first instanceof StreamingPropertyValue && TextValue.class.isAssignableFrom(((StreamingPropertyValue)first).getValueType())) {
            first = ((StreamingPropertyValue)first).readToString();
        }
        if (second instanceof StreamingPropertyValue && TextValue.class.isAssignableFrom(((StreamingPropertyValue)second).getValueType())) {
            second = ((StreamingPropertyValue)second).readToString();
        }
        if (first instanceof String) {
            first = ((String)first).toLowerCase();
        }
        if (second instanceof String) {
            second = ((String)second).toLowerCase();
        }
        if (first instanceof TextValue) {
            first = ((TextValue)first).toLower().asObjectCopy();
        }
        if (second instanceof TextValue) {
            second = ((TextValue)second).toLower().asObjectCopy();
        }
        if (first instanceof Long && second instanceof Long) {
            long firstLong = (Long)first;
            long secondLong = (Long)second;
            return Long.compare(firstLong, secondLong);
        }
        if (first instanceof Integer && second instanceof Integer) {
            int firstInt = (Integer)first;
            int secondInt = (Integer)second;
            return Integer.compare(firstInt, secondInt);
        }
        if (first instanceof Number && second instanceof Number) {
            double firstDouble = ((Number)first).doubleValue();
            double secondDouble = ((Number)second).doubleValue();
            return Double.compare(firstDouble, secondDouble);
        }
        if (first instanceof Number && second instanceof String) {
            try {
                double firstDouble = ((Number)first).doubleValue();
                double secondDouble = Double.parseDouble(second.toString());
                return Double.compare(firstDouble, secondDouble);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
        if (first instanceof String && second instanceof Number) {
            try {
                double firstDouble = Double.parseDouble(first.toString());
                double secondDouble = ((Number)second).doubleValue();
                return Double.compare(firstDouble, secondDouble);
            }
            catch (NumberFormatException ex) {
                return 1;
            }
        }
        if (first instanceof Comparable) {
            return ((Comparable)first).compareTo(second);
        }
        if (second instanceof Comparable) {
            return ((Comparable)second).compareTo(first);
        }
        if (first instanceof Value && second instanceof Value) {
            return AnyValues.COMPARATOR.compare((Value)first, (Value)second);
        }
        return first.equals(second) ? 0 : 1;
    }

    private static int compareCollections(Collection leftObj, Collection rightObj) {
        int sizeCompare = Integer.compare(leftObj.size(), rightObj.size());
        if (sizeCompare != 0) {
            return sizeCompare;
        }
        Iterator leftIt = leftObj.iterator();
        Iterator rightIt = rightObj.iterator();
        while (leftIt.hasNext() && rightIt.hasNext()) {
            int c = ObjectUtils.compare(leftIt.next(), rightIt.next());
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private static int compareStreams(Stream leftObj, Stream rightObj) {
        Iterator leftIt = leftObj.iterator();
        Iterator rightIt = rightObj.iterator();
        while (leftIt.hasNext() && rightIt.hasNext()) {
            int c = ObjectUtils.compare(leftIt.next(), rightIt.next());
            if (c == 0) continue;
            return c;
        }
        if (leftIt.hasNext()) {
            return -1;
        }
        if (rightIt.hasNext()) {
            return 1;
        }
        return 0;
    }
}

