/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.mware.ge.util.CloseableIterable;
import com.mware.ge.util.CloseableIterator;
import com.mware.ge.util.CloseableUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class OffsetAndSizeIterable<T>
implements CloseableIterable<T> {
    private boolean doneCalled;
    private final Iterable<T> iterable;
    private final int offset;
    private final Integer size;

    public OffsetAndSizeIterable(Iterable<T> iterable, int offset, Integer size) {
        this.iterable = iterable;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> it = this.iterable.iterator();
        return new CloseableIterator<T>(){
            private int currentOffset;
            private T next;
            private T current;

            @Override
            public boolean hasNext() {
                this.loadNext();
                if (this.next == null) {
                    this.close();
                }
                return this.next != null;
            }

            @Override
            public T next() {
                this.loadNext();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                this.current = this.next;
                this.next = null;
                return this.current;
            }

            @Override
            public void close() {
                CloseableUtils.closeQuietly(it);
                OffsetAndSizeIterable.this.callClose();
            }

            private void loadNext() {
                if (this.next != null) {
                    return;
                }
                while (it.hasNext()) {
                    Object n = it.next();
                    if (this.isInRange()) {
                        ++this.currentOffset;
                        this.next = n;
                        break;
                    }
                    ++this.currentOffset;
                }
            }

            private boolean isInRange() {
                return this.currentOffset >= OffsetAndSizeIterable.this.offset && (OffsetAndSizeIterable.this.size == null || this.currentOffset < OffsetAndSizeIterable.this.offset + OffsetAndSizeIterable.this.size);
            }
        };
    }

    private void callClose() {
        if (!this.doneCalled) {
            this.doneCalled = true;
            this.close();
        }
    }

    @Override
    public void close() {
    }
}

