/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.mware.ge.Property;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class PropertyCollection {
    private final ConcurrentSkipListSet<Property> propertiesList = new ConcurrentSkipListSet();
    private final Map<String, ConcurrentSkipListMap<String, ConcurrentSkipListSet<Property>>> propertiesByNameAndKey = new HashMap<String, ConcurrentSkipListMap<String, ConcurrentSkipListSet<Property>>>();

    public Iterable<Property> getProperties() {
        return this.propertiesList;
    }

    public synchronized Iterable<Property> getProperties(String key, String name) {
        if (key == null) {
            return this.getProperties(name);
        }
        Map propertiesByKey = this.propertiesByNameAndKey.get(name);
        if (propertiesByKey == null) {
            return new ArrayList<Property>();
        }
        ConcurrentSkipListSet properties = (ConcurrentSkipListSet)propertiesByKey.get(key);
        if (properties == null) {
            return new ArrayList<Property>();
        }
        return properties;
    }

    public synchronized Iterable<Property> getProperties(String name) {
        Map propertiesByKey = this.propertiesByNameAndKey.get(name);
        if (propertiesByKey == null) {
            return new ArrayList<Property>();
        }
        ArrayList<Property> results = new ArrayList<Property>();
        for (ConcurrentSkipListSet properties : propertiesByKey.values()) {
            results.addAll(properties);
        }
        return results;
    }

    public synchronized Property getProperty(String name, int index) {
        Map propertiesByKey = this.propertiesByNameAndKey.get(name);
        if (propertiesByKey == null) {
            return null;
        }
        for (ConcurrentSkipListSet properties : propertiesByKey.values()) {
            for (Property property : properties) {
                if (index == 0) {
                    return property;
                }
                --index;
            }
        }
        return null;
    }

    public synchronized Property getProperty(String key, String name, int index) {
        if (key == null) {
            return this.getProperty(name, index);
        }
        Map propertiesByKey = this.propertiesByNameAndKey.get(name);
        if (propertiesByKey == null) {
            return null;
        }
        ConcurrentSkipListSet properties = (ConcurrentSkipListSet)propertiesByKey.get(key);
        if (properties == null) {
            return null;
        }
        for (Property property : properties) {
            if (index == 0) {
                return property;
            }
            --index;
        }
        return null;
    }

    public synchronized void addProperty(Property property) {
        ConcurrentSkipListMap<String, ConcurrentSkipListSet<Property>> propertiesByKey = this.propertiesByNameAndKey.get(property.getName());
        if (propertiesByKey == null) {
            propertiesByKey = new ConcurrentSkipListMap();
            this.propertiesByNameAndKey.put(property.getName(), propertiesByKey);
        }
        if (null == property.getKey()) {
            return;
        }
        ConcurrentSkipListSet<Property> properties = propertiesByKey.get(property.getKey());
        if (properties == null) {
            properties = new ConcurrentSkipListSet();
            propertiesByKey.put(property.getKey(), properties);
        }
        properties.add(property);
        this.propertiesList.add(property);
    }

    public synchronized void removeProperty(Property property) {
        Map propertiesByKey = this.propertiesByNameAndKey.get(property.getName());
        if (propertiesByKey == null) {
            return;
        }
        if (null == property.getKey()) {
            return;
        }
        ConcurrentSkipListSet properties = (ConcurrentSkipListSet)propertiesByKey.get(property.getKey());
        if (properties == null) {
            return;
        }
        properties.remove(property);
        this.propertiesList.remove(property);
    }

    public synchronized Iterable<Property> removeProperties(String name) {
        ArrayList<Property> removedProperties = new ArrayList<Property>();
        Map propertiesByKey = this.propertiesByNameAndKey.get(name);
        if (propertiesByKey != null) {
            for (ConcurrentSkipListSet properties : propertiesByKey.values()) {
                for (Property property : properties) {
                    removedProperties.add(property);
                }
            }
        }
        for (Property property : removedProperties) {
            this.removeProperty(property);
        }
        return removedProperties;
    }
}

