/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mware.ge.Element;
import com.mware.ge.GeException;
import com.mware.ge.query.Query;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtils {
    private StreamUtils() {
    }

    public static Stream<Element> stream(Query ... queries) {
        return Arrays.stream(queries).map(query -> StreamSupport.stream(query.elements().spliterator(), false)).reduce(Stream::concat).orElseGet(Stream::empty);
    }

    @SafeVarargs
    public static <T> Stream<T> stream(Iterable<T> ... iterables) {
        List<Iterator> iterators = Arrays.stream(iterables).map(Iterable::iterator).collect(Collectors.toList());
        return StreamUtils.stream(iterators.toArray(new Iterator[iterables.length]));
    }

    @SafeVarargs
    public static <T> Stream<T> stream(Iterator<T> ... iterators) {
        return StreamUtils.withCloseHandler(Arrays.stream(iterators).map(StreamUtils::streamForIterator).reduce(Stream::concat).orElseGet(Stream::empty), iterators);
    }

    @SafeVarargs
    private static <T> Stream<T> withCloseHandler(Stream<T> stream, Iterator<T> ... iterators) {
        return (Stream)stream.onClose(() -> {
            for (Iterator iterator : iterators) {
                if (!(iterator instanceof AutoCloseable)) continue;
                try {
                    ((AutoCloseable)((Object)iterator)).close();
                }
                catch (Exception ex) {
                    throw new GeException(String.format("exception occurred when closing %s", iterator.getClass().getName()), ex);
                }
            }
        });
    }

    private static <T> Stream<T> streamForIterator(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
    }

    public static <T> Collector<T, ImmutableList.Builder<T>, ImmutableList<T>> toImmutableList() {
        return Collector.of(ImmutableList.Builder::new, ImmutableList.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableList.Builder::build, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ImmutableSet.Builder<T>, ImmutableSet<T>> toImmutableSet() {
        return Collector.of(ImmutableSet.Builder::new, ImmutableSet.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableSet.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T, K, V> Collector<T, ImmutableMap.Builder<K, V>, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Collector.of(ImmutableMap.Builder::new, (r, t) -> r.put(keyMapper.apply(t), valueMapper.apply(t)), (l, r) -> l.putAll((Map)r.build()), ImmutableMap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T> Collector<T, LinkedHashSet<T>, LinkedHashSet<T>> toLinkedHashSet() {
        return Collector.of(LinkedHashSet::new, HashSet::add, (a1, a2) -> {
            LinkedHashSet results = new LinkedHashSet();
            results.addAll(a1);
            results.addAll(a2);
            return results;
        }, ts -> ts, new Collector.Characteristics[0]);
    }

    public static <TItem, TReturn> TReturn ifEmpty(Stream<TItem> stream, Supplier<TReturn> trueFunc, Function<Stream<TItem>, TReturn> falseFunc) {
        Spliterator<Object> split = stream.spliterator();
        AtomicReference firstItem = new AtomicReference();
        if (split.tryAdvance(firstItem::set)) {
            Stream newStream = Stream.concat(Stream.of(firstItem.get()), StreamSupport.stream(split, stream.isParallel()));
            return falseFunc.apply(newStream);
        }
        return trueFunc.get();
    }

    public static <T> Predicate<T> distinctBy(Function<? super T, ?> fn) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(fn.apply(t));
    }

    public static <T, R> Stream<R> mapOptional(Stream<T> stream, Function<T, R> transform) {
        List l = stream.collect(Collectors.toList());
        if (l.size() == 0) {
            return Stream.of(null).map(transform);
        }
        return l.stream().map(transform);
    }

    public static <T> Iterable<T> toIterable(Stream<T> stream) {
        return stream::iterator;
    }
}

