/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class WrappedIterator<R>
implements Iterator<R>,
AutoCloseable {
    private static final Object NONE = new Object();
    protected R current = WrappedIterator.none();

    @Override
    public boolean hasNext() {
        if (this.current != WrappedIterator.none()) {
            return true;
        }
        return this.fetch();
    }

    @Override
    public R next() {
        if (this.current == WrappedIterator.none()) {
            this.fetch();
        }
        if (this.current == WrappedIterator.none()) {
            throw new NoSuchElementException();
        }
        R current = this.current;
        this.current = WrappedIterator.none();
        return current;
    }

    @Override
    public void remove() {
        Iterator<?> iterator = this.originIterator();
        if (iterator == null) {
            throw new NoSuchElementException("The origin iterator can't be null for removing");
        }
        iterator.remove();
    }

    @Override
    public void close() throws Exception {
        Iterator<?> iterator = this.originIterator();
        if (iterator instanceof AutoCloseable) {
            ((AutoCloseable)((Object)iterator)).close();
        }
    }

    protected static final <R> R none() {
        return (R)NONE;
    }

    protected abstract Iterator<?> originIterator();

    protected abstract boolean fetch();
}

