/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values;

import com.mware.ge.values.AnyValue;
import com.mware.ge.values.Comparison;
import com.mware.ge.values.SequenceValue;
import com.mware.ge.values.TernaryComparator;
import com.mware.ge.values.VirtualValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueComparator;
import com.mware.ge.values.storable.Values;
import com.mware.ge.values.virtual.VirtualValueGroup;
import java.util.Comparator;

class AnyValueComparator
implements Comparator<AnyValue>,
TernaryComparator<AnyValue> {
    private final Comparator<VirtualValueGroup> virtualValueGroupComparator;
    private final ValueComparator valueComparator;

    AnyValueComparator(ValueComparator valueComparator, Comparator<VirtualValueGroup> virtualValueGroupComparator) {
        this.virtualValueGroupComparator = virtualValueGroupComparator;
        this.valueComparator = valueComparator;
    }

    private Comparison cmp(AnyValue v1, AnyValue v2, boolean ternary) {
        assert (v1 != null && v2 != null) : "null values are not supported, use NoValue.NO_VALUE instead";
        if (v1 == v2) {
            return Comparison.EQUAL;
        }
        if (v1 == Values.NO_VALUE) {
            return Comparison.GREATER_THAN;
        }
        if (v2 == Values.NO_VALUE) {
            return Comparison.SMALLER_THAN;
        }
        boolean isSequence1 = v1.isSequenceValue();
        boolean isSequence2 = v2.isSequenceValue();
        if (isSequence1 && isSequence2) {
            return Comparison.from(this.compareSequences((SequenceValue)((Object)v1), (SequenceValue)((Object)v2)));
        }
        if (isSequence1) {
            return Comparison.from(this.compareSequenceAndNonSequence((SequenceValue)((Object)v1), v2));
        }
        if (isSequence2) {
            return Comparison.from(-this.compareSequenceAndNonSequence((SequenceValue)((Object)v2), v1));
        }
        boolean isValue1 = v1 instanceof Value;
        boolean isValue2 = v2 instanceof Value;
        int x = Boolean.compare(isValue1, isValue2);
        if (x == 0) {
            if (isValue1) {
                if (ternary) {
                    return this.valueComparator.ternaryCompare((Value)v1, (Value)v2);
                }
                return Comparison.from(this.valueComparator.compare((Value)v1, (Value)v2));
            }
            return Comparison.from(this.compareVirtualValues((VirtualValue)v1, (VirtualValue)v2));
        }
        return Comparison.from(x);
    }

    @Override
    public int compare(AnyValue v1, AnyValue v2) {
        return this.cmp(v1, v2, false).value();
    }

    @Override
    public Comparison ternaryCompare(AnyValue v1, AnyValue v2) {
        return this.cmp(v1, v2, true);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof AnyValueComparator;
    }

    public int hashCode() {
        return 1;
    }

    private int compareVirtualValues(VirtualValue v1, VirtualValue v2) {
        VirtualValueGroup id2;
        VirtualValueGroup id1 = v1.valueGroup();
        int x = this.virtualValueGroupComparator.compare(id1, id2 = v2.valueGroup());
        if (x == 0) {
            return v1.compareTo(v2, this);
        }
        return x;
    }

    private int compareSequenceAndNonSequence(SequenceValue v1, AnyValue v2) {
        boolean isValue2 = v2 instanceof Value;
        if (isValue2) {
            return -1;
        }
        return this.virtualValueGroupComparator.compare(VirtualValueGroup.LIST, ((VirtualValue)v2).valueGroup());
    }

    private int compareSequences(SequenceValue v1, SequenceValue v2) {
        return v1.compareToSequence(v2, this);
    }
}

