/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values;

import com.mware.ge.values.AnyValue;
import java.util.Comparator;
import java.util.Iterator;

public interface SequenceValue
extends Iterable<AnyValue> {
    public int length();

    public AnyValue value(int var1);

    @Override
    public Iterator<AnyValue> iterator();

    public IterationPreference iterationPreference();

    default public boolean equals(SequenceValue other) {
        if (other == null) {
            return false;
        }
        IterationPreference pref = this.iterationPreference();
        IterationPreference otherPref = other.iterationPreference();
        if (pref == IterationPreference.RANDOM_ACCESS && otherPref == IterationPreference.RANDOM_ACCESS) {
            return SequenceValue.equalsUsingRandomAccess(this, other);
        }
        return SequenceValue.equalsUsingIterators(this, other);
    }

    public static boolean equalsUsingRandomAccess(SequenceValue a, SequenceValue b) {
        boolean areEqual;
        boolean bl = areEqual = a.length() == b.length();
        for (int i = 0; areEqual && i < a.length(); ++i) {
            areEqual = a.value(i).equals(b.value(i));
        }
        return areEqual;
    }

    public static Boolean ternaryEqualsUsingRandomAccess(SequenceValue a, SequenceValue b) {
        if (a.length() != b.length()) {
            return Boolean.FALSE;
        }
        Boolean equivalenceResult = Boolean.TRUE;
        for (int i = 0; i < a.length(); ++i) {
            Boolean areEqual = a.value(i).ternaryEquals(b.value(i));
            if (areEqual == null) {
                equivalenceResult = null;
                continue;
            }
            if (areEqual.booleanValue()) continue;
            return Boolean.FALSE;
        }
        return equivalenceResult;
    }

    public static boolean equalsUsingIterators(SequenceValue a, SequenceValue b) {
        boolean areEqual = true;
        Iterator<AnyValue> aIterator = a.iterator();
        Iterator<AnyValue> bIterator = b.iterator();
        while (areEqual && aIterator.hasNext() && bIterator.hasNext()) {
            areEqual = aIterator.next().equals(bIterator.next());
        }
        return areEqual && aIterator.hasNext() == bIterator.hasNext();
    }

    public static Boolean ternaryEqualsUsingIterators(SequenceValue a, SequenceValue b) {
        Boolean equivalenceResult = Boolean.TRUE;
        Iterator<AnyValue> aIterator = a.iterator();
        Iterator<AnyValue> bIterator = b.iterator();
        while (aIterator.hasNext() && bIterator.hasNext()) {
            Boolean areEqual = aIterator.next().ternaryEquals(bIterator.next());
            if (areEqual == null) {
                equivalenceResult = null;
                continue;
            }
            if (areEqual.booleanValue()) continue;
            return Boolean.FALSE;
        }
        return aIterator.hasNext() == bIterator.hasNext() ? equivalenceResult : Boolean.FALSE;
    }

    default public int compareToSequence(SequenceValue other, Comparator<AnyValue> comparator) {
        IterationPreference pref = this.iterationPreference();
        IterationPreference otherPref = other.iterationPreference();
        if (pref == IterationPreference.RANDOM_ACCESS && otherPref == IterationPreference.RANDOM_ACCESS) {
            return SequenceValue.compareUsingRandomAccess(this, other, comparator);
        }
        return SequenceValue.compareUsingIterators(this, other, comparator);
    }

    public static int compareUsingRandomAccess(SequenceValue a, SequenceValue b, Comparator<AnyValue> comparator) {
        int x = 0;
        int length = Math.min(a.length(), b.length());
        for (int i = 0; x == 0 && i < length; ++i) {
            x = comparator.compare(a.value(i), b.value(i));
        }
        if (x == 0) {
            x = a.length() - b.length();
        }
        return x;
    }

    public static int compareUsingIterators(SequenceValue a, SequenceValue b, Comparator<AnyValue> comparator) {
        int x = 0;
        Iterator<AnyValue> aIterator = a.iterator();
        Iterator<AnyValue> bIterator = b.iterator();
        while (aIterator.hasNext() && bIterator.hasNext()) {
            x = comparator.compare(aIterator.next(), bIterator.next());
        }
        if (x == 0) {
            x = Boolean.compare(aIterator.hasNext(), bIterator.hasNext());
        }
        return x;
    }

    default public Boolean ternaryEquality(SequenceValue other) {
        IterationPreference pref = this.iterationPreference();
        IterationPreference otherPref = other.iterationPreference();
        if (pref == IterationPreference.RANDOM_ACCESS && otherPref == IterationPreference.RANDOM_ACCESS) {
            return SequenceValue.ternaryEqualsUsingRandomAccess(this, other);
        }
        return SequenceValue.ternaryEqualsUsingIterators(this, other);
    }

    public static enum IterationPreference {
        RANDOM_ACCESS,
        ITERATION;

    }
}

