/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values;

import com.mware.ge.values.AnyValue;
import com.mware.ge.values.InvalidValuesArgumentException;
import com.mware.ge.values.virtual.MapValue;
import java.util.Map;

public interface StructureBuilder<Input, Result> {
    public StructureBuilder<Input, Result> add(String var1, Input var2);

    public Result build();

    public static <T> T build(StructureBuilder<AnyValue, T> builder, MapValue map) {
        if (map.size() == 0) {
            throw new InvalidValuesArgumentException("At least one temporal unit must be specified.");
        }
        map.foreach(builder::add);
        return builder.build();
    }

    public static <T> T build(StructureBuilder<AnyValue, T> builder, Iterable<Map.Entry<String, AnyValue>> entries) {
        for (Map.Entry<String, AnyValue> entry : entries) {
            builder.add(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }
}

