/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values;

import com.mware.ge.values.SequenceValue;
import com.mware.ge.values.storable.BooleanArray;
import com.mware.ge.values.storable.BooleanValue;
import com.mware.ge.values.storable.ByteArray;
import com.mware.ge.values.storable.ByteValue;
import com.mware.ge.values.storable.CharArray;
import com.mware.ge.values.storable.CharValue;
import com.mware.ge.values.storable.DateArray;
import com.mware.ge.values.storable.DateTimeArray;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.DateValue;
import com.mware.ge.values.storable.DoubleArray;
import com.mware.ge.values.storable.DoubleValue;
import com.mware.ge.values.storable.DurationArray;
import com.mware.ge.values.storable.DurationValue;
import com.mware.ge.values.storable.FloatArray;
import com.mware.ge.values.storable.FloatValue;
import com.mware.ge.values.storable.FloatingPointArray;
import com.mware.ge.values.storable.FloatingPointValue;
import com.mware.ge.values.storable.GeoPointValue;
import com.mware.ge.values.storable.IntArray;
import com.mware.ge.values.storable.IntValue;
import com.mware.ge.values.storable.IntegralArray;
import com.mware.ge.values.storable.IntegralValue;
import com.mware.ge.values.storable.LocalDateTimeArray;
import com.mware.ge.values.storable.LocalDateTimeValue;
import com.mware.ge.values.storable.LocalTimeArray;
import com.mware.ge.values.storable.LocalTimeValue;
import com.mware.ge.values.storable.LongArray;
import com.mware.ge.values.storable.LongValue;
import com.mware.ge.values.storable.NumberArray;
import com.mware.ge.values.storable.NumberValue;
import com.mware.ge.values.storable.ShortArray;
import com.mware.ge.values.storable.ShortValue;
import com.mware.ge.values.storable.StringArray;
import com.mware.ge.values.storable.StringValue;
import com.mware.ge.values.storable.TextArray;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.TimeArray;
import com.mware.ge.values.storable.TimeValue;
import com.mware.ge.values.storable.Values;
import com.mware.ge.values.virtual.MapValue;
import com.mware.ge.values.virtual.PathValue;
import com.mware.ge.values.virtual.VirtualNodeValue;
import com.mware.ge.values.virtual.VirtualRelationshipValue;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public interface ValueMapper<Base> {
    public Base mapPath(PathValue var1);

    public Base mapNode(VirtualNodeValue var1);

    public Base mapRelationship(VirtualRelationshipValue var1);

    public Base mapMap(MapValue var1);

    public Base mapNoValue();

    public Base mapSequence(SequenceValue var1);

    public Base mapText(TextValue var1);

    default public Base mapString(StringValue value) {
        return this.mapText(value);
    }

    default public Base mapTextArray(TextArray value) {
        return this.mapSequence(value);
    }

    default public Base mapStringArray(StringArray value) {
        return this.mapTextArray(value);
    }

    default public Base mapChar(CharValue value) {
        return this.mapText(value);
    }

    default public Base mapCharArray(CharArray value) {
        return this.mapTextArray(value);
    }

    public Base mapBoolean(BooleanValue var1);

    default public Base mapBooleanArray(BooleanArray value) {
        return this.mapSequence(value);
    }

    public Base mapNumber(NumberValue var1);

    default public Base mapNumberArray(NumberArray value) {
        return this.mapSequence(value);
    }

    default public Base mapIntegral(IntegralValue value) {
        return this.mapNumber(value);
    }

    default public Base mapIntegralArray(IntegralArray value) {
        return this.mapNumberArray(value);
    }

    default public Base mapByte(ByteValue value) {
        return this.mapIntegral(value);
    }

    default public Base mapByteArray(ByteArray value) {
        return this.mapIntegralArray(value);
    }

    default public Base mapShort(ShortValue value) {
        return this.mapIntegral(value);
    }

    default public Base mapShortArray(ShortArray value) {
        return this.mapIntegralArray(value);
    }

    default public Base mapInt(IntValue value) {
        return this.mapIntegral(value);
    }

    default public Base mapIntArray(IntArray value) {
        return this.mapIntegralArray(value);
    }

    default public Base mapLong(LongValue value) {
        return this.mapIntegral(value);
    }

    default public Base mapLongArray(LongArray value) {
        return this.mapIntegralArray(value);
    }

    default public Base mapFloatingPoint(FloatingPointValue value) {
        return this.mapNumber(value);
    }

    default public Base mapFloatingPointArray(FloatingPointArray value) {
        return this.mapNumberArray(value);
    }

    default public Base mapDouble(DoubleValue value) {
        return this.mapFloatingPoint(value);
    }

    default public Base mapDoubleArray(DoubleArray value) {
        return this.mapFloatingPointArray(value);
    }

    default public Base mapFloat(FloatValue value) {
        return this.mapFloatingPoint(value);
    }

    default public Base mapFloatArray(FloatArray value) {
        return this.mapFloatingPointArray(value);
    }

    public Base mapDateTime(DateTimeValue var1);

    public Base mapLocalDateTime(LocalDateTimeValue var1);

    public Base mapDate(DateValue var1);

    public Base mapTime(TimeValue var1);

    public Base mapLocalTime(LocalTimeValue var1);

    public Base mapDuration(DurationValue var1);

    default public Base mapDateTimeArray(DateTimeArray value) {
        return this.mapSequence(value);
    }

    default public Base mapLocalDateTimeArray(LocalDateTimeArray value) {
        return this.mapSequence(value);
    }

    default public Base mapLocalTimeArray(LocalTimeArray value) {
        return this.mapSequence(value);
    }

    default public Base mapTimeArray(TimeArray value) {
        return this.mapSequence(value);
    }

    default public Base mapDateArray(DateArray value) {
        return this.mapSequence(value);
    }

    default public Base mapDurationArray(DurationArray value) {
        return this.mapSequence(value);
    }

    default public Base mapGeoPoint(GeoPointValue geoPointValue) {
        return this.mapText(Values.stringValue(geoPointValue.prettyPrint()));
    }

    public static abstract class JavaMapper
    implements ValueMapper<Object> {
        @Override
        public Object mapNoValue() {
            return null;
        }

        @Override
        public Object mapMap(MapValue value) {
            HashMap map = new HashMap();
            value.foreach((k, v) -> map.put(k, v.map(this)));
            return map;
        }

        @Override
        public List<?> mapSequence(SequenceValue value) {
            ArrayList list = new ArrayList(value.length());
            value.forEach(v -> list.add(v.map(this)));
            return list;
        }

        @Override
        public Character mapChar(CharValue value) {
            return Character.valueOf(value.value());
        }

        @Override
        public String mapText(TextValue value) {
            return value.stringValue();
        }

        @Override
        public String[] mapStringArray(StringArray value) {
            return value.asObjectCopy();
        }

        @Override
        public char[] mapCharArray(CharArray value) {
            return value.asObjectCopy();
        }

        @Override
        public Boolean mapBoolean(BooleanValue value) {
            return value.booleanValue();
        }

        @Override
        public boolean[] mapBooleanArray(BooleanArray value) {
            return value.asObjectCopy();
        }

        @Override
        public Number mapNumber(NumberValue value) {
            return value.asObject();
        }

        @Override
        public byte[] mapByteArray(ByteArray value) {
            return value.asObjectCopy();
        }

        @Override
        public short[] mapShortArray(ShortArray value) {
            return value.asObjectCopy();
        }

        @Override
        public int[] mapIntArray(IntArray value) {
            return value.asObjectCopy();
        }

        @Override
        public long[] mapLongArray(LongArray value) {
            return value.asObjectCopy();
        }

        @Override
        public float[] mapFloatArray(FloatArray value) {
            return value.asObjectCopy();
        }

        @Override
        public double[] mapDoubleArray(DoubleArray value) {
            return value.asObjectCopy();
        }

        @Override
        public ZonedDateTime mapDateTime(DateTimeValue value) {
            return (ZonedDateTime)value.asObjectCopy();
        }

        @Override
        public LocalDateTime mapLocalDateTime(LocalDateTimeValue value) {
            return (LocalDateTime)value.asObjectCopy();
        }

        @Override
        public LocalDate mapDate(DateValue value) {
            return (LocalDate)value.asObjectCopy();
        }

        @Override
        public OffsetTime mapTime(TimeValue value) {
            return (OffsetTime)value.asObjectCopy();
        }

        @Override
        public LocalTime mapLocalTime(LocalTimeValue value) {
            return (LocalTime)value.asObjectCopy();
        }

        @Override
        public TemporalAmount mapDuration(DurationValue value) {
            return value.asObjectCopy();
        }
    }
}

