/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.hashing.HashFunction;
import com.mware.ge.values.AnyValue;
import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.ArrayValue;
import com.mware.ge.values.storable.NumberType;
import com.mware.ge.values.storable.NumberValues;
import com.mware.ge.values.storable.PrimitiveArrayWriting;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueGroup;
import com.mware.ge.values.storable.ValueWriter;
import com.mware.ge.values.storable.Values;
import java.util.Arrays;

public class BooleanArray
extends ArrayValue {
    private final boolean[] value;

    BooleanArray(boolean[] value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    public boolean booleanValue(int offset) {
        return this.value[offset];
    }

    @Override
    public String getTypeName() {
        return "BooleanArray";
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(boolean[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public int computeHash() {
        return NumberValues.hash(this.value);
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        hash = hashFunction.update(hash, this.value.length);
        hash = hashFunction.update(hash, this.hashCode());
        return hash;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapBooleanArray(this);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value);
    }

    public boolean[] asObjectCopy() {
        return (boolean[])this.value.clone();
    }

    @Deprecated
    public boolean[] asObject() {
        return this.value;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return NumberValues.compareBooleanArrays(this, (BooleanArray)otherValue);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.BOOLEAN_ARRAY;
    }

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value);
    }

    @Override
    public AnyValue value(int position) {
        return Values.booleanValue(this.booleanValue(position));
    }

    public String toString() {
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.value));
    }
}

