/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.hashing.HashFunction;
import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.NumberType;
import com.mware.ge.values.storable.ScalarValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueGroup;
import com.mware.ge.values.storable.ValueWriter;

public abstract class BooleanValue
extends ScalarValue {
    public static final BooleanValue TRUE = new BooleanValue(){

        @Override
        public boolean equals(Value other) {
            return this == other;
        }

        @Override
        public boolean equals(boolean x) {
            return x;
        }

        @Override
        public int computeHash() {
            return 1231;
        }

        @Override
        public boolean booleanValue() {
            return true;
        }

        @Override
        int unsafeCompareTo(Value otherValue) {
            BooleanValue other = (BooleanValue)otherValue;
            return other.booleanValue() ? 0 : 1;
        }

        @Override
        public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
            writer.writeBoolean(true);
        }

        @Override
        public Object asObjectCopy() {
            return Boolean.TRUE;
        }

        @Override
        public String prettyPrint() {
            return Boolean.toString(true);
        }

        public String toString() {
            return String.format("%s('%s')", this.getTypeName(), Boolean.toString(true));
        }
    };
    public static final BooleanValue FALSE = new BooleanValue(){

        @Override
        public boolean equals(Value other) {
            return this == other;
        }

        @Override
        public boolean equals(boolean x) {
            return !x;
        }

        @Override
        public int computeHash() {
            return 1237;
        }

        @Override
        public boolean booleanValue() {
            return false;
        }

        @Override
        int unsafeCompareTo(Value otherValue) {
            BooleanValue other = (BooleanValue)otherValue;
            return !other.booleanValue() ? 0 : -1;
        }

        @Override
        public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
            writer.writeBoolean(false);
        }

        @Override
        public Object asObjectCopy() {
            return Boolean.FALSE;
        }

        @Override
        public String prettyPrint() {
            return Boolean.toString(false);
        }

        public String toString() {
            return String.format("%s('%s')", this.getTypeName(), Boolean.toString(false));
        }
    };

    private BooleanValue() {
    }

    @Override
    public boolean eq(Object other) {
        return other instanceof Value && this.equals((Value)other);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapBoolean(this);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.BOOLEAN;
    }

    public abstract boolean booleanValue();

    @Override
    public NumberType numberType() {
        return NumberType.NO_NUMBER;
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        return hashFunction.update(hash, this.hashCode());
    }

    @Override
    public String getTypeName() {
        return "Boolean";
    }
}

