/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.hashing.HashFunction;
import com.mware.ge.values.AnyValue;
import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.CharValue;
import com.mware.ge.values.storable.NumberValues;
import com.mware.ge.values.storable.PrimitiveArrayValues;
import com.mware.ge.values.storable.PrimitiveArrayWriting;
import com.mware.ge.values.storable.TextArray;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueWriter;
import com.mware.ge.values.storable.Values;
import java.util.Arrays;

public class CharArray
extends TextArray {
    private final char[] value;

    CharArray(char[] value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(char[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public boolean equals(String[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public int computeHash() {
        return NumberValues.hash(this.value);
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        hash = hashFunction.update(hash, this.value.length);
        for (char c : this.value) {
            hash = CharValue.updateHash(hashFunction, hash, c);
        }
        return hash;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public String stringValue(int offset) {
        return Character.toString(this.value[offset]);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value);
    }

    public char[] asObjectCopy() {
        return (char[])this.value.clone();
    }

    @Deprecated
    public char[] asObject() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value);
    }

    @Override
    public AnyValue value(int position) {
        return Values.charValue(this.value[position]);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapCharArray(this);
    }

    public String toString() {
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.value));
    }

    @Override
    public String getTypeName() {
        return "CharArray";
    }
}

