/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.DateValue;
import com.mware.ge.values.storable.TemporalArray;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueGroup;
import com.mware.ge.values.storable.ValueWriter;
import java.time.LocalDate;
import java.util.Arrays;

public class DateArray
extends TemporalArray<LocalDate, DateValue> {
    private final LocalDate[] value;

    DateArray(LocalDate[] value) {
        assert (value != null);
        this.value = value;
    }

    protected LocalDate[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDateArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(LocalDate[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        this.writeTo(writer, ValueWriter.ArrayType.DATE, this.value);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.DATE_ARRAY;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((DateArray)otherValue);
    }

    @Override
    public String getTypeName() {
        return "DateArray";
    }
}

