/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.TemporalArray;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueGroup;
import com.mware.ge.values.storable.ValueWriter;
import java.time.ZonedDateTime;
import java.util.Arrays;

public class DateTimeArray
extends TemporalArray<ZonedDateTime, DateTimeValue> {
    private final ZonedDateTime[] value;

    DateTimeArray(ZonedDateTime[] value) {
        assert (value != null);
        this.value = value;
    }

    protected ZonedDateTime[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDateTimeArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(ZonedDateTime[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        this.writeTo(writer, ValueWriter.ArrayType.ZONED_DATE_TIME, this.value);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.ZONED_DATE_TIME_ARRAY;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((DateTimeArray)otherValue);
    }

    @Override
    public String getTypeName() {
        return "DateTimeArray";
    }
}

