/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.FloatingPointValue;
import com.mware.ge.values.storable.ValueWriter;

public final class DoubleValue
extends FloatingPointValue {
    private final double value;

    DoubleValue(double value) {
        this.value = value;
    }

    public double value() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeFloatingPoint(this.value);
    }

    @Override
    public Double asObjectCopy() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Double.toString(this.value);
    }

    public String toString() {
        return String.format("%s(%e)", this.getTypeName(), this.value);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDouble(this);
    }

    @Override
    public String getTypeName() {
        return "Double";
    }
}

