/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.values.AnyValue;
import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.DurationValue;
import com.mware.ge.values.storable.NonPrimitiveArray;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueGroup;
import com.mware.ge.values.storable.ValueWriter;
import com.mware.ge.values.storable.Values;
import java.util.Arrays;

public class DurationArray
extends NonPrimitiveArray<DurationValue> {
    private final DurationValue[] value;

    DurationArray(DurationValue[] value) {
        assert (value != null);
        this.value = value;
    }

    protected DurationValue[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDurationArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(DurationValue[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.beginArray(this.value.length, ValueWriter.ArrayType.DURATION);
        for (DurationValue x : this.value) {
            x.writeTo(writer);
        }
        writer.endArray();
    }

    @Override
    public AnyValue value(int offset) {
        return Values.durationValue(this.value[offset]);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.DURATION_ARRAY;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((DurationArray)otherValue);
    }

    @Override
    public String getTypeName() {
        return "DurationArray";
    }
}

