/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.values.AnyValue;
import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.FloatingPointArray;
import com.mware.ge.values.storable.NumberValues;
import com.mware.ge.values.storable.PrimitiveArrayValues;
import com.mware.ge.values.storable.PrimitiveArrayWriting;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueWriter;
import com.mware.ge.values.storable.Values;
import java.util.Arrays;

public class FloatArray
extends FloatingPointArray {
    private final float[] value;

    FloatArray(float[] value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public double doubleValue(int index) {
        return this.value[index];
    }

    @Override
    public int computeHash() {
        return NumberValues.hash(this.value);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapFloatArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(byte[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(short[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(int[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(long[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(float[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public boolean equals(double[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value);
    }

    public float[] asObjectCopy() {
        return (float[])this.value.clone();
    }

    @Deprecated
    public float[] asObject() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value);
    }

    @Override
    public AnyValue value(int offset) {
        return Values.floatValue(this.value[offset]);
    }

    public String toString() {
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.value));
    }

    @Override
    public String getTypeName() {
        return "FloatArray";
    }
}

