/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.hashing.HashFunction;
import com.mware.ge.values.storable.DoubleValue;
import com.mware.ge.values.storable.IntegralValue;
import com.mware.ge.values.storable.NumberType;
import com.mware.ge.values.storable.NumberValue;
import com.mware.ge.values.storable.NumberValues;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.Values;
import com.mware.ge.values.utils.ValueMath;

public abstract class FloatingPointValue
extends NumberValue {
    @Override
    public final boolean equals(long x) {
        return NumberValues.numbersEqual(this.doubleValue(), x);
    }

    @Override
    public final boolean equals(double x) {
        return this.doubleValue() == x;
    }

    @Override
    public final int computeHash() {
        return NumberValues.hash(this.doubleValue());
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        return hashFunction.update(hash, Double.doubleToLongBits(this.doubleValue()));
    }

    @Override
    public boolean eq(Object other) {
        return other instanceof Value && this.equals((Value)other);
    }

    @Override
    public final boolean equals(Value other) {
        if (other instanceof FloatingPointValue) {
            FloatingPointValue that = (FloatingPointValue)other;
            return this.doubleValue() == that.doubleValue();
        }
        if (other instanceof IntegralValue) {
            IntegralValue that = (IntegralValue)other;
            return NumberValues.numbersEqual(this.doubleValue(), that.longValue());
        }
        return false;
    }

    @Override
    public NumberType numberType() {
        return NumberType.FLOATING_POINT;
    }

    @Override
    public int compareTo(IntegralValue other) {
        return NumberValues.compareDoubleAgainstLong(this.doubleValue(), other.longValue());
    }

    @Override
    public int compareTo(FloatingPointValue other) {
        return Double.compare(this.doubleValue(), other.doubleValue());
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.doubleValue());
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public DoubleValue minus(long b) {
        return ValueMath.subtract(this.doubleValue(), (double)b);
    }

    @Override
    public DoubleValue minus(double b) {
        return ValueMath.subtract(this.doubleValue(), b);
    }

    @Override
    public DoubleValue plus(long b) {
        return ValueMath.add(this.doubleValue(), (double)b);
    }

    @Override
    public DoubleValue plus(double b) {
        return ValueMath.add(this.doubleValue(), b);
    }

    @Override
    public DoubleValue times(long b) {
        return ValueMath.multiply(this.doubleValue(), (double)b);
    }

    @Override
    public DoubleValue times(double b) {
        return ValueMath.multiply(this.doubleValue(), b);
    }

    @Override
    public DoubleValue dividedBy(long b) {
        return Values.doubleValue(this.doubleValue() / (double)b);
    }

    @Override
    public DoubleValue dividedBy(double b) {
        return Values.doubleValue(this.doubleValue() / b);
    }
}

