/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.csv.CSVHeaderInformation;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.values.AnyValue;
import com.mware.ge.values.InvalidValuesArgumentException;
import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.DoubleValue;
import com.mware.ge.values.storable.FloatingPointValue;
import com.mware.ge.values.storable.GeoPointFields;
import com.mware.ge.values.storable.GeoShapeValue;
import com.mware.ge.values.storable.IntegralValue;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueWriter;
import com.mware.ge.values.storable.Values;
import com.mware.ge.values.virtual.MapValue;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class GeoPointValue
extends GeoShapeValue
implements Comparable<GeoPointValue> {
    public static final GeoPointValue MIN_VALUE_CARTESIAN = new GeoPointValue(new GeoPoint(Double.MIN_VALUE, Double.MIN_VALUE));
    public static final GeoPointValue MAX_VALUE_CARTESIAN = new GeoPointValue(new GeoPoint(Double.MAX_VALUE, Double.MAX_VALUE));
    public static final GeoPointValue MIN_VALUE_WGS84 = new GeoPointValue(new GeoPoint(-180.0, -90.0));
    public static final GeoPointValue MAX_VALUE_WGS84 = new GeoPointValue(new GeoPoint(180.0, 90.0));

    GeoPointValue(GeoPoint geoPoint) {
        super(geoPoint);
    }

    public static AnyValue of(String str) {
        return new GeoPointValue(GeoPoint.parse(str));
    }

    @Override
    public int compareTo(GeoPointValue o) {
        return ((GeoPoint)this.geoShape).compareTo((GeoPoint)o.geoShape);
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareTo((GeoPointValue)otherValue);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeGeoPoint((GeoPoint)this.geoShape);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapGeoPoint(this);
    }

    @Override
    public String getTypeName() {
        return "GeoPointValue";
    }

    public DoubleValue getLongitude() {
        return Values.doubleValue(((GeoPoint)this.geoShape).getLongitude());
    }

    public DoubleValue getLatitude() {
        return Values.doubleValue(((GeoPoint)this.geoShape).getLatitude());
    }

    public DoubleValue getAltitude() {
        return Values.doubleValue(((GeoPoint)this.geoShape).getAltitude());
    }

    public Value get(String fieldName) {
        return GeoPointFields.fromName(fieldName).get(this);
    }

    public static GeoPointValue fromMap(MapValue map) {
        GeoPointBuilder fields = new GeoPointBuilder();
        map.foreach((key, value) -> fields.assign(key.toLowerCase(), value));
        return GeoPointValue.fromInputFields(fields);
    }

    private static GeoPointValue fromInputFields(GeoPointBuilder fields) {
        double[] coordinates;
        if (fields.x != null && fields.y != null) {
            double[] dArray;
            if (fields.z != null) {
                double[] dArray2 = new double[3];
                dArray2[0] = fields.x;
                dArray2[1] = fields.y;
                dArray = dArray2;
                dArray2[2] = fields.z;
            } else {
                double[] dArray3 = new double[2];
                dArray3[0] = fields.x;
                dArray = dArray3;
                dArray3[1] = fields.y;
            }
            coordinates = dArray;
        } else if (fields.latitude != null && fields.longitude != null) {
            coordinates = fields.z != null ? new double[]{fields.longitude, fields.latitude, fields.z} : (fields.height != null ? new double[]{fields.longitude, fields.latitude, fields.height} : new double[]{fields.longitude, fields.latitude});
        } else {
            throw new InvalidValuesArgumentException("A point must contain either 'x' and 'y' or 'latitude' and 'longitude'");
        }
        return Values.geoPointValue(coordinates[1], coordinates[0]);
    }

    public static GeoPointBuilder parseHeaderInformation(CharSequence text) {
        GeoPointBuilder fields = new GeoPointBuilder();
        Value.parseHeaderInformation(text, "point", fields);
        return fields;
    }

    public static GeoPointValue parse(CharSequence text, CSVHeaderInformation fieldsFromHeader) {
        GeoPointBuilder fieldsFromData = GeoPointValue.parseHeaderInformation(text);
        if (fieldsFromHeader != null) {
            if (!(fieldsFromHeader instanceof GeoPointBuilder)) {
                throw new IllegalStateException("Wrong header information type: " + fieldsFromHeader);
            }
            fieldsFromData.mergeWithHeader((GeoPointBuilder)fieldsFromHeader);
        }
        return GeoPointValue.fromInputFields(fieldsFromData);
    }

    private static class GeoPointBuilder
    implements CSVHeaderInformation {
        private String crs;
        private Double x;
        private Double y;
        private Double z;
        private Double longitude;
        private Double latitude;
        private Double height;
        private int srid = -1;

        private GeoPointBuilder() {
        }

        @Override
        public void assign(String key, Object value) {
            switch (key.toLowerCase()) {
                case "crs": {
                    this.checkUnassigned(this.crs, key);
                    this.assignTextValue(key, value, str -> {
                        this.crs = Value.quotesPattern.matcher((CharSequence)str).replaceAll("");
                    });
                    break;
                }
                case "x": {
                    this.checkUnassigned(this.x, key);
                    this.assignFloatingPoint(key, value, i -> {
                        this.x = i;
                    });
                    break;
                }
                case "y": {
                    this.checkUnassigned(this.y, key);
                    this.assignFloatingPoint(key, value, i -> {
                        this.y = i;
                    });
                    break;
                }
                case "z": {
                    this.checkUnassigned(this.z, key);
                    this.assignFloatingPoint(key, value, i -> {
                        this.z = i;
                    });
                    break;
                }
                case "longitude": {
                    this.checkUnassigned(this.longitude, key);
                    this.assignFloatingPoint(key, value, i -> {
                        this.longitude = i;
                    });
                    break;
                }
                case "latitude": {
                    this.checkUnassigned(this.latitude, key);
                    this.assignFloatingPoint(key, value, i -> {
                        this.latitude = i;
                    });
                    break;
                }
                case "height": {
                    this.checkUnassigned(this.height, key);
                    this.assignFloatingPoint(key, value, i -> {
                        this.height = i;
                    });
                    break;
                }
                case "srid": {
                    if (this.srid != -1) {
                        throw new InvalidValuesArgumentException(String.format("Duplicate field '%s' is not allowed.", key));
                    }
                    this.assignIntegral(key, value, i -> {
                        this.srid = i;
                    });
                    break;
                }
            }
        }

        void mergeWithHeader(GeoPointBuilder header) {
            this.crs = this.crs == null ? header.crs : this.crs;
            this.x = this.x == null ? header.x : this.x;
            this.y = this.y == null ? header.y : this.y;
            this.z = this.z == null ? header.z : this.z;
            this.longitude = this.longitude == null ? header.longitude : this.longitude;
            this.latitude = this.latitude == null ? header.latitude : this.latitude;
            this.height = this.height == null ? header.height : this.height;
            this.srid = this.srid == -1 ? header.srid : this.srid;
        }

        private void assignTextValue(String key, Object value, Consumer<String> assigner) {
            if (value instanceof String) {
                assigner.accept((String)value);
            } else if (value instanceof TextValue) {
                assigner.accept(((TextValue)value).stringValue());
            } else {
                throw new InvalidValuesArgumentException(String.format("Cannot assign %s to field %s", value, key));
            }
        }

        private void assignFloatingPoint(String key, Object value, Consumer<Double> assigner) {
            if (value instanceof String) {
                assigner.accept(this.assertConvertible(() -> Double.parseDouble((String)value)));
            } else if (value instanceof IntegralValue) {
                assigner.accept(((IntegralValue)value).doubleValue());
            } else if (value instanceof FloatingPointValue) {
                assigner.accept(((FloatingPointValue)value).doubleValue());
            } else {
                throw new InvalidValuesArgumentException(String.format("Cannot assign %s to field %s", value, key));
            }
        }

        private void assignIntegral(String key, Object value, Consumer<Integer> assigner) {
            if (value instanceof String) {
                assigner.accept(this.assertConvertible(() -> Integer.parseInt((String)value)));
            } else if (value instanceof IntegralValue) {
                assigner.accept((int)((IntegralValue)value).longValue());
            } else {
                throw new InvalidValuesArgumentException(String.format("Cannot assign %s to field %s", value, key));
            }
        }

        private <T extends Number> T assertConvertible(Supplier<T> func) {
            try {
                return (T)((Number)func.get());
            }
            catch (NumberFormatException e) {
                throw new InvalidValuesArgumentException(e.getMessage(), e);
            }
        }

        private void checkUnassigned(Object key, String fieldName) {
            if (key != null) {
                throw new InvalidValuesArgumentException(String.format("Duplicate field '%s' is not allowed.", fieldName));
            }
        }
    }
}

