/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.values.AnyValue;
import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.IntegralArray;
import com.mware.ge.values.storable.NumberValues;
import com.mware.ge.values.storable.PrimitiveArrayValues;
import com.mware.ge.values.storable.PrimitiveArrayWriting;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueWriter;
import com.mware.ge.values.storable.Values;
import java.util.Arrays;

public class IntArray
extends IntegralArray {
    private final int[] value;

    IntArray(int[] value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public long longValue(int index) {
        return this.value[index];
    }

    @Override
    public int computeHash() {
        return NumberValues.hash(this.value);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapIntArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(byte[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(short[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(int[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public boolean equals(long[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public boolean equals(float[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public boolean equals(double[] x) {
        return PrimitiveArrayValues.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value);
    }

    public int[] asObjectCopy() {
        return (int[])this.value.clone();
    }

    @Deprecated
    public int[] asObject() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value);
    }

    @Override
    public AnyValue value(int offset) {
        return Values.intValue(this.value[offset]);
    }

    public String toString() {
        return String.format("IntArray%s", Arrays.toString(this.value));
    }

    @Override
    public String getTypeName() {
        return "IntegerArray";
    }
}

