/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.LocalTimeValue;
import com.mware.ge.values.storable.TemporalArray;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueGroup;
import com.mware.ge.values.storable.ValueWriter;
import java.time.LocalTime;
import java.util.Arrays;

public class LocalTimeArray
extends TemporalArray<LocalTime, LocalTimeValue> {
    private final LocalTime[] value;

    LocalTimeArray(LocalTime[] value) {
        assert (value != null);
        this.value = value;
    }

    protected LocalTime[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapLocalTimeArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(LocalTime[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        this.writeTo(writer, ValueWriter.ArrayType.LOCAL_TIME, this.value);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.LOCAL_TIME_ARRAY;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((LocalTimeArray)otherValue);
    }

    @Override
    public String getTypeName() {
        return "LocalTimeArray";
    }
}

