/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.IntegralValue;
import com.mware.ge.values.storable.ValueWriter;

public final class LongValue
extends IntegralValue {
    private final long value;

    LongValue(long value) {
        this.value = value;
    }

    public long value() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeInteger(this.value);
    }

    @Override
    public Long asObjectCopy() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Long.toString(this.value);
    }

    public String toString() {
        return String.format("%s(%d)", this.getTypeName(), this.value);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapLong(this);
    }

    @Override
    public String getTypeName() {
        return "Long";
    }
}

