/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.values.AnyValue;
import com.mware.ge.values.storable.FloatingPointValue;
import com.mware.ge.values.storable.IntegralValue;
import com.mware.ge.values.storable.ScalarValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueGroup;

public abstract class NumberValue
extends ScalarValue {
    public static double safeCastFloatingPoint(String name, AnyValue value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof IntegralValue) {
            return ((IntegralValue)value).doubleValue();
        }
        if (value instanceof FloatingPointValue) {
            return ((FloatingPointValue)value).doubleValue();
        }
        throw new IllegalArgumentException(name + " must be a number value, but was a " + value.getClass().getSimpleName());
    }

    public abstract double doubleValue();

    public abstract long longValue();

    public abstract int compareTo(IntegralValue var1);

    public abstract int compareTo(FloatingPointValue var1);

    @Override
    int unsafeCompareTo(Value otherValue) {
        if (otherValue instanceof IntegralValue) {
            return this.compareTo((IntegralValue)otherValue);
        }
        if (otherValue instanceof FloatingPointValue) {
            return this.compareTo((FloatingPointValue)otherValue);
        }
        throw new IllegalArgumentException("Cannot compare different values");
    }

    @Override
    public abstract Number asObjectCopy();

    @Override
    public Number asObject() {
        return this.asObjectCopy();
    }

    @Override
    public final boolean equals(boolean x) {
        return false;
    }

    @Override
    public final boolean equals(char x) {
        return false;
    }

    @Override
    public final boolean equals(String x) {
        return false;
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.NUMBER;
    }

    public abstract NumberValue minus(long var1);

    public abstract NumberValue minus(double var1);

    public abstract NumberValue plus(long var1);

    public abstract NumberValue plus(double var1);

    public abstract NumberValue times(long var1);

    public abstract NumberValue times(double var1);

    public abstract NumberValue dividedBy(long var1);

    public abstract NumberValue dividedBy(double var1);

    public NumberValue minus(NumberValue numberValue) {
        if (numberValue instanceof IntegralValue) {
            return this.minus(numberValue.longValue());
        }
        if (numberValue instanceof FloatingPointValue) {
            return this.minus(numberValue.doubleValue());
        }
        throw new IllegalArgumentException("Cannot subtract " + numberValue);
    }

    public NumberValue plus(NumberValue numberValue) {
        if (numberValue instanceof IntegralValue) {
            return this.plus(numberValue.longValue());
        }
        if (numberValue instanceof FloatingPointValue) {
            return this.plus(numberValue.doubleValue());
        }
        throw new IllegalArgumentException("Cannot add " + numberValue);
    }

    public NumberValue times(NumberValue numberValue) {
        if (numberValue instanceof IntegralValue) {
            return this.times(numberValue.longValue());
        }
        if (numberValue instanceof FloatingPointValue) {
            return this.times(numberValue.doubleValue());
        }
        throw new IllegalArgumentException("Cannot multiply with " + numberValue);
    }

    public NumberValue divideBy(NumberValue numberValue) {
        if (numberValue instanceof IntegralValue) {
            return this.dividedBy(numberValue.longValue());
        }
        if (numberValue instanceof FloatingPointValue) {
            return this.dividedBy(numberValue.doubleValue());
        }
        throw new IllegalArgumentException("Cannot divide by " + numberValue);
    }
}

