/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.GeException;
import com.mware.ge.util.IOUtils;
import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.DefaultStreamingPropertyValue;
import com.mware.ge.values.storable.StreamingPropertyValueBase;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public abstract class StreamingPropertyValue
extends StreamingPropertyValueBase
implements Serializable {
    private static final long serialVersionUID = -8009009221695795406L;
    private final Class<? extends Value> valueType;

    public StreamingPropertyValue(Class<? extends Value> valueType) {
        this.valueType = valueType;
    }

    public Class<? extends Value> getValueType() {
        return this.valueType;
    }

    public abstract Long getLength();

    public abstract InputStream getInputStream();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readToString() {
        try (InputStream in = this.getInputStream();){
            if (in.markSupported()) {
                in.reset();
            }
            String string = IOUtils.toString(in);
            return string;
        }
        catch (IOException e) {
            throw new GeException("Could not read streaming property value into string", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readToString(long offset, long limit) {
        try (InputStream in = this.getInputStream();){
            if (in.markSupported()) {
                in.reset();
            }
            String string = IOUtils.toString(in, offset, limit);
            return string;
        }
        catch (IOException e) {
            throw new GeException("Could not read streaming property value into string", e);
        }
    }

    public static StreamingPropertyValue create(String value) {
        ByteArrayInputStream data = new ByteArrayInputStream(value.getBytes());
        return new DefaultStreamingPropertyValue(data, TextValue.class);
    }

    public static StreamingPropertyValue create(InputStream inputStream, Class<? extends Value> type, Long length) {
        return new DefaultStreamingPropertyValue(inputStream, type, length);
    }

    public static StreamingPropertyValue create(InputStream inputStream, Class<? extends Value> type) {
        return new DefaultStreamingPropertyValue(inputStream, type, null);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeString(this.readToString());
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    int unsafeCompareTo(Value other) {
        throw new IllegalArgumentException("Cannot compare streaming properties");
    }

    @Override
    public Object asObject() {
        return this.getInputStream();
    }

    @Override
    public Object asObjectCopy() {
        return this.asObject();
    }

    @Override
    public String getTypeName() {
        return "StreamingPropertyValue";
    }

    @Override
    public String prettyPrint() {
        return this.toString();
    }

    public String toString() {
        return "StreamingPropertyValue{valueType=" + this.getValueType() + ", length=" + this.getLength() + '}';
    }
}

