/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.hashing.HashFunction;
import com.mware.ge.values.AnyValue;
import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.PrimitiveArrayValues;
import com.mware.ge.values.storable.PrimitiveArrayWriting;
import com.mware.ge.values.storable.StringWrappingStringValue;
import com.mware.ge.values.storable.TextArray;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueWriter;
import com.mware.ge.values.storable.Values;
import java.util.Arrays;

public class StringArray
extends TextArray {
    private final String[] value;

    StringArray(String[] value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public String stringValue(int offset) {
        return this.value[offset];
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(char[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(String[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public int computeHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        hash = hashFunction.update(hash, this.value.length);
        for (String s : this.value) {
            hash = StringWrappingStringValue.updateHash(hashFunction, hash, s);
        }
        return hash;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value);
    }

    public String[] asObjectCopy() {
        return (String[])this.value.clone();
    }

    @Deprecated
    public String[] asObject() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        return Arrays.toString(this.value);
    }

    @Override
    public AnyValue value(int offset) {
        return Values.stringOrNoValue(this.stringValue(offset));
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapStringArray(this);
    }

    public String toString() {
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.value));
    }

    @Override
    public String getTypeName() {
        return "StringArray";
    }
}

