/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.storable.TemporalArray;
import com.mware.ge.values.storable.TimeValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueGroup;
import com.mware.ge.values.storable.ValueWriter;
import java.time.OffsetTime;
import java.util.Arrays;

public class TimeArray
extends TemporalArray<OffsetTime, TimeValue> {
    private final OffsetTime[] value;

    TimeArray(OffsetTime[] value) {
        assert (value != null);
        this.value = value;
    }

    protected OffsetTime[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapTimeArray(this);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(OffsetTime[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        this.writeTo(writer, ValueWriter.ArrayType.ZONED_TIME, this.value);
    }

    @Override
    public ValueGroup valueGroup() {
        return ValueGroup.ZONED_TIME_ARRAY;
    }

    @Override
    int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((TimeArray)otherValue);
    }

    @Override
    public String getTypeName() {
        return "TimeArray";
    }
}

