/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable;

import com.mware.ge.Range;
import com.mware.ge.type.GeoCircle;
import com.mware.ge.type.GeoCollection;
import com.mware.ge.type.GeoHash;
import com.mware.ge.type.GeoLine;
import com.mware.ge.type.GeoPoint;
import com.mware.ge.type.GeoPolygon;
import com.mware.ge.type.GeoRect;
import com.mware.ge.type.GeoShape;
import com.mware.ge.values.storable.ArrayValue;
import com.mware.ge.values.storable.BooleanArray;
import com.mware.ge.values.storable.BooleanValue;
import com.mware.ge.values.storable.ByteArray;
import com.mware.ge.values.storable.ByteValue;
import com.mware.ge.values.storable.CharArray;
import com.mware.ge.values.storable.CharValue;
import com.mware.ge.values.storable.DateArray;
import com.mware.ge.values.storable.DateTimeArray;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.DateValue;
import com.mware.ge.values.storable.DoubleArray;
import com.mware.ge.values.storable.DoubleValue;
import com.mware.ge.values.storable.DurationArray;
import com.mware.ge.values.storable.DurationValue;
import com.mware.ge.values.storable.FloatArray;
import com.mware.ge.values.storable.FloatValue;
import com.mware.ge.values.storable.FloatingPointValue;
import com.mware.ge.values.storable.GeoCircleValue;
import com.mware.ge.values.storable.GeoCollectionValue;
import com.mware.ge.values.storable.GeoHashValue;
import com.mware.ge.values.storable.GeoLineValue;
import com.mware.ge.values.storable.GeoPointValue;
import com.mware.ge.values.storable.GeoPolygonValue;
import com.mware.ge.values.storable.GeoRectValue;
import com.mware.ge.values.storable.GeoShapeValue;
import com.mware.ge.values.storable.IntArray;
import com.mware.ge.values.storable.IntValue;
import com.mware.ge.values.storable.IntegralValue;
import com.mware.ge.values.storable.LocalDateTimeArray;
import com.mware.ge.values.storable.LocalDateTimeValue;
import com.mware.ge.values.storable.LocalTimeArray;
import com.mware.ge.values.storable.LocalTimeValue;
import com.mware.ge.values.storable.LongArray;
import com.mware.ge.values.storable.LongValue;
import com.mware.ge.values.storable.NoValue;
import com.mware.ge.values.storable.NumberValue;
import com.mware.ge.values.storable.ShortArray;
import com.mware.ge.values.storable.ShortValue;
import com.mware.ge.values.storable.StringArray;
import com.mware.ge.values.storable.StringValue;
import com.mware.ge.values.storable.StringWrappingStringValue;
import com.mware.ge.values.storable.TemporalArray;
import com.mware.ge.values.storable.TemporalValue;
import com.mware.ge.values.storable.TextArray;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.TimeArray;
import com.mware.ge.values.storable.TimeValue;
import com.mware.ge.values.storable.UTF8StringValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueComparator;
import com.mware.ge.values.storable.ValueGroup;
import java.lang.reflect.Array;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Objects;

public final class Values {
    public static final Value MIN_NUMBER = Values.doubleValue(Double.NEGATIVE_INFINITY);
    public static final Value MAX_NUMBER = Values.doubleValue(Double.NaN);
    public static final Value ZERO_FLOAT = Values.doubleValue(0.0);
    public static final IntegralValue ZERO_INT = Values.longValue(0L);
    public static final Value MIN_STRING = StringValue.EMPTY;
    public static final Value MAX_STRING = Values.booleanValue(false);
    public static final BooleanValue TRUE = Values.booleanValue(true);
    public static final BooleanValue FALSE = Values.booleanValue(false);
    public static final TextValue EMPTY_STRING = StringValue.EMPTY;
    public static final DoubleValue E = Values.doubleValue(Math.E);
    public static final DoubleValue PI = Values.doubleValue(Math.PI);
    public static final ArrayValue EMPTY_SHORT_ARRAY = Values.shortArray(new short[0]);
    public static final ArrayValue EMPTY_BOOLEAN_ARRAY = Values.booleanArray(new boolean[0]);
    public static final ArrayValue EMPTY_BYTE_ARRAY = Values.byteArray(new byte[0]);
    public static final ArrayValue EMPTY_CHAR_ARRAY = Values.charArray(new char[0]);
    public static final ArrayValue EMPTY_INT_ARRAY = Values.intArray(new int[0]);
    public static final ArrayValue EMPTY_LONG_ARRAY = Values.longArray(new long[0]);
    public static final ArrayValue EMPTY_FLOAT_ARRAY = Values.floatArray(new float[0]);
    public static final ArrayValue EMPTY_DOUBLE_ARRAY = Values.doubleArray(new double[0]);
    public static final TextArray EMPTY_TEXT_ARRAY = Values.stringArray(new String[0]);
    public static final ValueComparator COMPARATOR = new ValueComparator(Enum::compareTo);
    public static final Value NO_VALUE = NoValue.NO_VALUE;

    private Values() {
    }

    public static boolean isNumberValue(Object value) {
        return value instanceof NumberValue;
    }

    public static boolean isBooleanValue(Object value) {
        return value instanceof BooleanValue;
    }

    public static boolean isTextValue(Object value) {
        return value instanceof TextValue;
    }

    public static boolean isArrayValue(Value value) {
        return value instanceof ArrayValue;
    }

    public static boolean isTemporalValue(Value value) {
        return value instanceof TemporalValue || value instanceof DurationValue;
    }

    public static boolean isTemporalArray(Value value) {
        return value instanceof TemporalArray || value instanceof DurationArray;
    }

    public static double coerceToDouble(Value value) {
        if (value instanceof IntegralValue) {
            return ((IntegralValue)value).longValue();
        }
        if (value instanceof FloatingPointValue) {
            return ((FloatingPointValue)value).doubleValue();
        }
        throw new UnsupportedOperationException(String.format("Cannot coerce %s to double", value));
    }

    public static TextValue utf8Value(byte[] bytes) {
        if (bytes.length == 0) {
            return EMPTY_STRING;
        }
        return Values.utf8Value(bytes, 0, bytes.length);
    }

    public static TextValue utf8Value(byte[] bytes, int offset, int length) {
        if (length == 0) {
            return EMPTY_STRING;
        }
        return new UTF8StringValue(bytes, offset, length);
    }

    public static GeoPointValue geoPointValue(double lat, double lon) {
        return new GeoPointValue(new GeoPoint(lat, lon));
    }

    public static GeoPointValue geoPointValue(GeoPoint geoPoint) {
        return new GeoPointValue(geoPoint);
    }

    public static GeoCircleValue geoCircleValue(double latitude, double longitude, double radius) {
        return new GeoCircleValue(new GeoCircle(latitude, longitude, radius));
    }

    public static GeoCircleValue geoCircleValue(GeoCircle geoCircle) {
        return new GeoCircleValue(geoCircle);
    }

    public static GeoRectValue geoRectValue(GeoPoint northWest, GeoPoint southEast) {
        return new GeoRectValue(new GeoRect(northWest, southEast));
    }

    public static GeoRectValue geoRectValue(GeoRect geoRect) {
        return new GeoRectValue(geoRect);
    }

    public static GeoHashValue geoHashValue(GeoHash geoHash) {
        return new GeoHashValue(geoHash);
    }

    public static GeoCollectionValue geoCollectionValue(GeoCollection geoCollection) {
        return new GeoCollectionValue(geoCollection);
    }

    public static GeoPolygonValue geoPolygonValue(GeoPolygon geoPolygon) {
        return new GeoPolygonValue(geoPolygon);
    }

    public static GeoLineValue geoLineValue(GeoLine geoLine) {
        return new GeoLineValue(geoLine);
    }

    public static GeoShapeValue geoShapeValue(GeoShape geoShape) {
        if (geoShape instanceof GeoPoint) {
            return Values.geoPointValue((GeoPoint)geoShape);
        }
        if (geoShape instanceof GeoCircle) {
            return Values.geoCircleValue((GeoCircle)geoShape);
        }
        if (geoShape instanceof GeoRect) {
            return Values.geoRectValue((GeoRect)geoShape);
        }
        if (geoShape instanceof GeoPolygon) {
            return Values.geoPolygonValue((GeoPolygon)geoShape);
        }
        if (geoShape instanceof GeoCollection) {
            return Values.geoCollectionValue((GeoCollection)geoShape);
        }
        if (geoShape instanceof GeoHash) {
            return Values.geoHashValue((GeoHash)geoShape);
        }
        if (geoShape instanceof GeoLine) {
            return Values.geoLineValue((GeoLine)geoShape);
        }
        throw new IllegalArgumentException("Don't know how to handle geoshape: " + geoShape.getClass());
    }

    public static TextValue stringValue(String value) {
        if (value == null || value.isEmpty()) {
            return EMPTY_STRING;
        }
        return new StringWrappingStringValue(value);
    }

    public static Value stringOrNoValue(String value) {
        if (value == null) {
            return NO_VALUE;
        }
        return Values.stringValue(value);
    }

    public static NumberValue numberValue(Number number) {
        if (number instanceof Long) {
            return Values.longValue(number.longValue());
        }
        if (number instanceof Integer) {
            return Values.intValue(number.intValue());
        }
        if (number instanceof Double) {
            return Values.doubleValue(number.doubleValue());
        }
        if (number instanceof Byte) {
            return Values.byteValue(number.byteValue());
        }
        if (number instanceof Float) {
            return Values.floatValue(number.floatValue());
        }
        if (number instanceof Short) {
            return Values.shortValue(number.shortValue());
        }
        throw new UnsupportedOperationException("Unsupported type of Number " + number.toString());
    }

    public static LongValue longValue(long value) {
        return new LongValue(value);
    }

    public static IntValue intValue(int value) {
        return new IntValue(value);
    }

    public static ShortValue shortValue(short value) {
        return new ShortValue(value);
    }

    public static ByteValue byteValue(byte value) {
        return new ByteValue(value);
    }

    public static BooleanValue booleanValue(boolean value) {
        return value ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public static CharValue charValue(char value) {
        return new CharValue(value);
    }

    public static DoubleValue doubleValue(double value) {
        return new DoubleValue(value);
    }

    public static FloatValue floatValue(float value) {
        return new FloatValue(value);
    }

    public static TextArray stringArray(String ... value) {
        return new StringArray(value);
    }

    public static ByteArray byteArray(byte[] value) {
        return new ByteArray(value);
    }

    public static LongArray longArray(long[] value) {
        return new LongArray(value);
    }

    public static IntArray intArray(int[] value) {
        return new IntArray(value);
    }

    public static DoubleArray doubleArray(double[] value) {
        return new DoubleArray(value);
    }

    public static FloatArray floatArray(float[] value) {
        return new FloatArray(value);
    }

    public static BooleanArray booleanArray(boolean[] value) {
        return new BooleanArray(value);
    }

    public static CharArray charArray(char[] value) {
        return new CharArray(value);
    }

    public static ShortArray shortArray(short[] value) {
        return new ShortArray(value);
    }

    public static Value temporalRangeValue(Range range) {
        if (range.getStart() instanceof ZonedDateTime && range.getEnd() instanceof ZonedDateTime) {
            return Values.dateTimeArray(new ZonedDateTime[]{(ZonedDateTime)range.getStart(), (ZonedDateTime)range.getEnd()});
        }
        throw new IllegalArgumentException("Range must contain ZonedDateTime values");
    }

    public static Value temporalValue(Temporal value) {
        if (value instanceof ZonedDateTime) {
            return DateTimeValue.datetime((ZonedDateTime)value);
        }
        if (value instanceof OffsetDateTime) {
            return DateTimeValue.datetime((OffsetDateTime)value);
        }
        if (value instanceof LocalDateTime) {
            return LocalDateTimeValue.localDateTime((LocalDateTime)value);
        }
        if (value instanceof OffsetTime) {
            return TimeValue.time((OffsetTime)value);
        }
        if (value instanceof LocalDate) {
            return DateValue.date((LocalDate)value);
        }
        if (value instanceof LocalTime) {
            return LocalTimeValue.localTime((LocalTime)value);
        }
        if (value instanceof TemporalValue) {
            return (Value)((Object)value);
        }
        if (value == null) {
            return NO_VALUE;
        }
        throw new UnsupportedOperationException("Unsupported type of Temporal " + value.toString());
    }

    public static DurationValue durationValue(TemporalAmount value) {
        if (value instanceof Duration) {
            return DurationValue.duration((Duration)value);
        }
        if (value instanceof Period) {
            return DurationValue.duration((Period)value);
        }
        if (value instanceof DurationValue) {
            return (DurationValue)value;
        }
        DurationValue duration = DurationValue.duration(0L, 0L, 0L, 0L);
        for (TemporalUnit unit : value.getUnits()) {
            duration = duration.plus(value.get(unit), unit);
        }
        return duration;
    }

    public static DateTimeArray dateTimeArray(ZonedDateTime[] values) {
        return new DateTimeArray(values);
    }

    public static LocalDateTimeArray localDateTimeArray(LocalDateTime[] values) {
        return new LocalDateTimeArray(values);
    }

    public static LocalTimeArray localTimeArray(LocalTime[] values) {
        return new LocalTimeArray(values);
    }

    public static TimeArray timeArray(OffsetTime[] values) {
        return new TimeArray(values);
    }

    public static DateArray dateArray(LocalDate[] values) {
        return new DateArray(values);
    }

    public static DurationArray durationArray(DurationValue[] values) {
        return new DurationArray(values);
    }

    public static DurationArray durationArray(TemporalAmount[] values) {
        DurationValue[] durations = new DurationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            durations[i] = Values.durationValue(values[i]);
        }
        return new DurationArray(durations);
    }

    public static Value of(Object value) {
        return Values.of(value, true);
    }

    public static Value of(Object value, boolean allowNull) {
        Value of = Values.unsafeOf(value, allowNull);
        if (of != null) {
            return of;
        }
        Objects.requireNonNull(value);
        throw new IllegalArgumentException(String.format("[%s:%s] is not a supported property value", value, value.getClass().getName()));
    }

    public static Value unsafeOf(Object value, boolean allowNull) {
        if (value instanceof String) {
            return Values.stringValue((String)value);
        }
        if (value instanceof Object[]) {
            return Values.arrayValue((Object[])value);
        }
        if (value instanceof Boolean) {
            return Values.booleanValue((Boolean)value);
        }
        if (value instanceof Number) {
            return Values.numberValue((Number)value);
        }
        if (value instanceof Character) {
            return Values.charValue(((Character)value).charValue());
        }
        if (value instanceof Temporal) {
            return Values.temporalValue((Temporal)value);
        }
        if (value instanceof Range) {
            return Values.temporalRangeValue((Range)value);
        }
        if (value instanceof TemporalAmount) {
            return Values.durationValue((TemporalAmount)value);
        }
        if (value instanceof GeoPoint) {
            return Values.geoPointValue((GeoPoint)value);
        }
        if (value instanceof GeoCircle) {
            return Values.geoCircleValue((GeoCircle)value);
        }
        if (value instanceof GeoLine) {
            return Values.geoLineValue((GeoLine)value);
        }
        if (value instanceof GeoRect) {
            return Values.geoRectValue((GeoRect)value);
        }
        if (value instanceof GeoPolygon) {
            return Values.geoPolygonValue((GeoPolygon)value);
        }
        if (value instanceof GeoCollection) {
            return Values.geoCollectionValue((GeoCollection)value);
        }
        if (value instanceof GeoHash) {
            return Values.geoHashValue((GeoHash)value);
        }
        if (value instanceof byte[]) {
            return Values.byteArray((byte[])((byte[])value).clone());
        }
        if (value instanceof long[]) {
            return Values.longArray((long[])((long[])value).clone());
        }
        if (value instanceof int[]) {
            return Values.intArray((int[])((int[])value).clone());
        }
        if (value instanceof double[]) {
            return Values.doubleArray((double[])((double[])value).clone());
        }
        if (value instanceof float[]) {
            return Values.floatArray((float[])((float[])value).clone());
        }
        if (value instanceof boolean[]) {
            return Values.booleanArray((boolean[])((boolean[])value).clone());
        }
        if (value instanceof char[]) {
            return Values.charArray((char[])((char[])value).clone());
        }
        if (value instanceof short[]) {
            return Values.shortArray((short[])((short[])value).clone());
        }
        if (value == null) {
            if (allowNull) {
                return NoValue.NO_VALUE;
            }
            throw new IllegalArgumentException("[null] is not a supported property value");
        }
        if (value instanceof Value) {
            throw new UnsupportedOperationException("Converting a Value to a Value using Values.of() is not supported.");
        }
        return null;
    }

    public static Value[] values(Object ... objects) {
        return (Value[])Arrays.stream(objects).map(Values::of).toArray(Value[]::new);
    }

    @Deprecated
    public static Object asObject(Value value) {
        return value == null ? null : value.asObject();
    }

    public static Object[] asObjects(Value[] propertyValues) {
        Object[] legacy = new Object[propertyValues.length];
        for (int i = 0; i < propertyValues.length; ++i) {
            legacy[i] = propertyValues[i].asObjectCopy();
        }
        return legacy;
    }

    private static Value arrayValue(Object[] value) {
        if (value instanceof String[]) {
            return Values.stringArray(Values.copy(value, new String[value.length]));
        }
        if (value instanceof Byte[]) {
            return Values.byteArray(Values.copy(value, new byte[value.length]));
        }
        if (value instanceof Long[]) {
            return Values.longArray(Values.copy(value, new long[value.length]));
        }
        if (value instanceof Integer[]) {
            return Values.intArray(Values.copy(value, new int[value.length]));
        }
        if (value instanceof Double[]) {
            return Values.doubleArray(Values.copy(value, new double[value.length]));
        }
        if (value instanceof Float[]) {
            return Values.floatArray(Values.copy(value, new float[value.length]));
        }
        if (value instanceof Boolean[]) {
            return Values.booleanArray(Values.copy(value, new boolean[value.length]));
        }
        if (value instanceof Character[]) {
            return Values.charArray(Values.copy(value, new char[value.length]));
        }
        if (value instanceof Short[]) {
            return Values.shortArray(Values.copy(value, new short[value.length]));
        }
        if (value instanceof ZonedDateTime[]) {
            return Values.dateTimeArray(Values.copy(value, new ZonedDateTime[value.length]));
        }
        if (value instanceof LocalDateTime[]) {
            return Values.localDateTimeArray(Values.copy(value, new LocalDateTime[value.length]));
        }
        if (value instanceof LocalTime[]) {
            return Values.localTimeArray(Values.copy(value, new LocalTime[value.length]));
        }
        if (value instanceof OffsetTime[]) {
            return Values.timeArray(Values.copy(value, new OffsetTime[value.length]));
        }
        if (value instanceof LocalDate[]) {
            return Values.dateArray(Values.copy(value, new LocalDate[value.length]));
        }
        if (value instanceof TemporalAmount[]) {
            return Values.durationArray((TemporalAmount[])value);
        }
        return null;
    }

    private static <T> T copy(Object[] value, T target) {
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException("Property array value elements may not be null.");
            }
            Array.set(target, i, value[i]);
        }
        return target;
    }

    public static Value minValue(ValueGroup valueGroup, Value value) {
        switch (valueGroup) {
            case TEXT: {
                return MIN_STRING;
            }
            case NUMBER: {
                return MIN_NUMBER;
            }
            case DATE: {
                return DateValue.MIN_VALUE;
            }
            case LOCAL_DATE_TIME: {
                return LocalDateTimeValue.MIN_VALUE;
            }
            case ZONED_DATE_TIME: {
                return DateTimeValue.MIN_VALUE;
            }
            case LOCAL_TIME: {
                return LocalTimeValue.MIN_VALUE;
            }
            case ZONED_TIME: {
                return TimeValue.MIN_VALUE;
            }
        }
        throw new IllegalStateException(String.format("The minValue for valueGroup %s is not defined yet", new Object[]{valueGroup}));
    }

    public static Value maxValue(ValueGroup valueGroup, Value value) {
        switch (valueGroup) {
            case TEXT: {
                return MAX_STRING;
            }
            case NUMBER: {
                return MAX_NUMBER;
            }
            case DATE: {
                return DateValue.MAX_VALUE;
            }
            case LOCAL_DATE_TIME: {
                return LocalDateTimeValue.MAX_VALUE;
            }
            case ZONED_DATE_TIME: {
                return DateTimeValue.MAX_VALUE;
            }
            case LOCAL_TIME: {
                return LocalTimeValue.MAX_VALUE;
            }
            case ZONED_TIME: {
                return TimeValue.MAX_VALUE;
            }
        }
        throw new IllegalStateException(String.format("The maxValue for valueGroup %s is not defined yet", new Object[]{valueGroup}));
    }
}

