/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.storable.random;

import com.mware.ge.values.storable.BooleanArray;
import com.mware.ge.values.storable.BooleanValue;
import com.mware.ge.values.storable.ByteArray;
import com.mware.ge.values.storable.ByteValue;
import com.mware.ge.values.storable.CharArray;
import com.mware.ge.values.storable.CharValue;
import com.mware.ge.values.storable.DateArray;
import com.mware.ge.values.storable.DateTimeArray;
import com.mware.ge.values.storable.DateTimeValue;
import com.mware.ge.values.storable.DateValue;
import com.mware.ge.values.storable.DoubleArray;
import com.mware.ge.values.storable.DoubleValue;
import com.mware.ge.values.storable.DurationArray;
import com.mware.ge.values.storable.DurationValue;
import com.mware.ge.values.storable.FloatArray;
import com.mware.ge.values.storable.FloatValue;
import com.mware.ge.values.storable.GeoPointValue;
import com.mware.ge.values.storable.IntArray;
import com.mware.ge.values.storable.IntValue;
import com.mware.ge.values.storable.LocalDateTimeArray;
import com.mware.ge.values.storable.LocalDateTimeValue;
import com.mware.ge.values.storable.LocalTimeArray;
import com.mware.ge.values.storable.LocalTimeValue;
import com.mware.ge.values.storable.LongArray;
import com.mware.ge.values.storable.LongValue;
import com.mware.ge.values.storable.ShortArray;
import com.mware.ge.values.storable.ShortValue;
import com.mware.ge.values.storable.StringArray;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.storable.TimeArray;
import com.mware.ge.values.storable.TimeValue;
import com.mware.ge.values.storable.Value;
import com.mware.ge.values.storable.ValueGroup;
import com.mware.ge.values.storable.random.ExtremeValuesLibrary;
import java.util.Arrays;

public enum ValueType {
    BOOLEAN(ValueGroup.BOOLEAN, BooleanValue.class, ExtremeValuesLibrary.EXTREME_BOOLEAN),
    BYTE(ValueGroup.NUMBER, ByteValue.class, ExtremeValuesLibrary.EXTREME_BYTE),
    SHORT(ValueGroup.NUMBER, ShortValue.class, ExtremeValuesLibrary.EXTREME_SHORT),
    INT(ValueGroup.NUMBER, IntValue.class, ExtremeValuesLibrary.EXTREME_INT),
    LONG(ValueGroup.NUMBER, LongValue.class, ExtremeValuesLibrary.EXTREME_LONG),
    FLOAT(ValueGroup.NUMBER, FloatValue.class, ExtremeValuesLibrary.EXTREME_FLOAT),
    DOUBLE(ValueGroup.NUMBER, DoubleValue.class, ExtremeValuesLibrary.EXTREME_DOUBLE),
    CHAR(ValueGroup.TEXT, CharValue.class, ExtremeValuesLibrary.EXTREME_CHAR),
    STRING(ValueGroup.TEXT, TextValue.class, ExtremeValuesLibrary.EXTREME_STRING),
    STRING_ALPHANUMERIC(ValueGroup.TEXT, TextValue.class, ExtremeValuesLibrary.EXTREME_STRING_ALPHANUMERIC),
    STRING_ASCII(ValueGroup.TEXT, TextValue.class, ExtremeValuesLibrary.EXTREME_STRING_ASCII),
    STRING_BMP(ValueGroup.TEXT, TextValue.class, ExtremeValuesLibrary.EXTREME_STRING_BMP),
    LOCAL_DATE_TIME(ValueGroup.LOCAL_DATE_TIME, LocalDateTimeValue.class, ExtremeValuesLibrary.EXTREME_LOCAL_DATE_TIME),
    DATE(ValueGroup.DATE, DateValue.class, ExtremeValuesLibrary.EXTREME_DATE),
    LOCAL_TIME(ValueGroup.LOCAL_TIME, LocalTimeValue.class, ExtremeValuesLibrary.EXTREME_LOCAL_TIME),
    PERIOD(ValueGroup.DURATION, DurationValue.class, ExtremeValuesLibrary.EXTREME_PERIOD),
    DURATION(ValueGroup.DURATION, DurationValue.class, ExtremeValuesLibrary.EXTREME_DURATION),
    TIME(ValueGroup.ZONED_TIME, TimeValue.class, ExtremeValuesLibrary.EXTREME_TIME),
    DATE_TIME(ValueGroup.ZONED_DATE_TIME, DateTimeValue.class, ExtremeValuesLibrary.EXTREME_DATE_TIME),
    CARTESIAN_POINT(ValueGroup.GEOMETRY, GeoPointValue.class, ExtremeValuesLibrary.EXTREME_CARTESIAN_POINT),
    GEOGRAPHIC_POINT(ValueGroup.GEOMETRY, GeoPointValue.class, ExtremeValuesLibrary.EXTREME_GEOGRAPHIC_POINT),
    BOOLEAN_ARRAY(ValueGroup.BOOLEAN_ARRAY, BooleanArray.class, true, ExtremeValuesLibrary.EXTREME_BOOLEAN_ARRAY),
    BYTE_ARRAY(ValueGroup.NUMBER_ARRAY, ByteArray.class, true, ExtremeValuesLibrary.EXTREME_BYTE_ARRAY),
    SHORT_ARRAY(ValueGroup.NUMBER_ARRAY, ShortArray.class, true, ExtremeValuesLibrary.EXTREME_SHORT_ARRAY),
    INT_ARRAY(ValueGroup.NUMBER_ARRAY, IntArray.class, true, ExtremeValuesLibrary.EXTREME_INT_ARRAY),
    LONG_ARRAY(ValueGroup.NUMBER_ARRAY, LongArray.class, true, ExtremeValuesLibrary.EXTREME_LONG_ARRAY),
    FLOAT_ARRAY(ValueGroup.NUMBER_ARRAY, FloatArray.class, true, ExtremeValuesLibrary.EXTREME_FLOAT_ARRAY),
    DOUBLE_ARRAY(ValueGroup.NUMBER_ARRAY, DoubleArray.class, true, ExtremeValuesLibrary.EXTREME_DOUBLE_ARRAY),
    CHAR_ARRAY(ValueGroup.TEXT_ARRAY, CharArray.class, true, ExtremeValuesLibrary.EXTREME_CHAR_ARRAY),
    STRING_ARRAY(ValueGroup.TEXT_ARRAY, StringArray.class, true, ExtremeValuesLibrary.EXTREME_STRING_ARRAY),
    STRING_ALPHANUMERIC_ARRAY(ValueGroup.TEXT_ARRAY, StringArray.class, true, ExtremeValuesLibrary.EXTREME_STRING_ALPHANUMERIC_ARRAY),
    STRING_ASCII_ARRAY(ValueGroup.TEXT_ARRAY, StringArray.class, true, ExtremeValuesLibrary.EXTREME_STRING_ASCII_ARRAY),
    STRING_BMP_ARRAY(ValueGroup.TEXT_ARRAY, StringArray.class, true, ExtremeValuesLibrary.EXTREME_STRING_BMP_ARRAY),
    LOCAL_DATE_TIME_ARRAY(ValueGroup.LOCAL_DATE_TIME_ARRAY, LocalDateTimeArray.class, true, ExtremeValuesLibrary.EXTREME_LOCAL_DATE_TIME_ARRAY),
    DATE_ARRAY(ValueGroup.DATE_ARRAY, DateArray.class, true, ExtremeValuesLibrary.EXTREME_DATE_ARRAY),
    LOCAL_TIME_ARRAY(ValueGroup.LOCAL_TIME_ARRAY, LocalTimeArray.class, true, ExtremeValuesLibrary.EXTREME_LOCAL_TIME_ARRAY),
    PERIOD_ARRAY(ValueGroup.DURATION_ARRAY, DurationArray.class, true, ExtremeValuesLibrary.EXTREME_PERIOD_ARRAY),
    DURATION_ARRAY(ValueGroup.DURATION_ARRAY, DurationArray.class, true, ExtremeValuesLibrary.EXTREME_DURATION_ARRAY),
    TIME_ARRAY(ValueGroup.ZONED_TIME_ARRAY, TimeArray.class, true, ExtremeValuesLibrary.EXTREME_TIME_ARRAY),
    DATE_TIME_ARRAY(ValueGroup.ZONED_DATE_TIME_ARRAY, DateTimeArray.class, true, ExtremeValuesLibrary.EXTREME_DATE_TIME_ARRAY);

    public final ValueGroup valueGroup;
    public final Class<? extends Value> valueClass;
    public final boolean arrayType;
    private final Value[] extremeValues;

    private ValueType(ValueGroup valueGroup, Class<? extends Value> valueClass, Value ... extremeValues) {
        this(valueGroup, valueClass, false, extremeValues);
    }

    private ValueType(ValueGroup valueGroup, Class<? extends Value> valueClass, boolean arrayType, Value ... extremeValues) {
        this.valueGroup = valueGroup;
        this.valueClass = valueClass;
        this.arrayType = arrayType;
        this.extremeValues = extremeValues;
    }

    public Value[] extremeValues() {
        return this.extremeValues;
    }

    static ValueType[] arrayTypes() {
        return (ValueType[])Arrays.stream(ValueType.values()).filter(t -> t.arrayType).toArray(ValueType[]::new);
    }
}

