/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.utils;

import com.mware.ge.values.storable.DoubleValue;
import com.mware.ge.values.storable.IntegralValue;
import com.mware.ge.values.storable.LongValue;
import com.mware.ge.values.storable.NumberValue;
import com.mware.ge.values.storable.Values;

public final class ValueMath {
    private ValueMath() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static LongValue add(long a, long b) {
        return Values.longValue(Math.addExact(a, b));
    }

    public static NumberValue overflowSafeAdd(NumberValue a, NumberValue b) {
        if (a instanceof IntegralValue && b instanceof IntegralValue) {
            return ValueMath.overflowSafeAdd(a.longValue(), b.longValue());
        }
        return a.plus(b);
    }

    public static NumberValue overflowSafeAdd(long a, long b) {
        long r = a + b;
        if (((a ^ r) & (b ^ r)) < 0L) {
            return Values.doubleValue((double)a + (double)b);
        }
        return Values.longValue(r);
    }

    public static DoubleValue add(double a, double b) {
        return Values.doubleValue(a + b);
    }

    public static LongValue subtract(long a, long b) {
        return Values.longValue(Math.subtractExact(a, b));
    }

    public static NumberValue overflowSafeSubtract(long a, long b) {
        long r = a - b;
        if (((a ^ b) & (a ^ r)) < 0L) {
            return Values.doubleValue((double)a - (double)b);
        }
        return Values.longValue(r);
    }

    public static DoubleValue subtract(double a, double b) {
        return Values.doubleValue(a - b);
    }

    public static LongValue multiply(long a, long b) {
        return Values.longValue(Math.multiplyExact(a, b));
    }

    public static NumberValue overflowSafeMultiply(long a, long b) {
        long ab;
        long r = a * b;
        long aa = Math.abs(a);
        if ((aa | (ab = Math.abs(b))) >>> 31 != 0L && (b != 0L && r / b != a || a == Long.MIN_VALUE && b == -1L)) {
            return Values.doubleValue((double)a * (double)b);
        }
        return Values.longValue(r);
    }

    public static DoubleValue multiply(double a, double b) {
        return Values.doubleValue(a * b);
    }
}

