/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.virtual;

import com.mware.ge.values.AnyValue;
import com.mware.ge.values.VirtualValue;
import com.mware.ge.values.storable.Value;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

final class ArrayHelpers {
    private ArrayHelpers() {
    }

    static boolean isSortedSet(int[] keys) {
        for (int i = 0; i < keys.length - 1; ++i) {
            if (keys[i] < keys[i + 1]) continue;
            return false;
        }
        return true;
    }

    static boolean isSortedSet(VirtualValue[] keys, Comparator<AnyValue> comparator) {
        for (int i = 0; i < keys.length - 1; ++i) {
            if (comparator.compare(keys[i], keys[i + 1]) < 0) continue;
            return false;
        }
        return true;
    }

    static boolean isSortedSet(Value[] keys, Comparator<AnyValue> comparator) {
        for (int i = 0; i < keys.length - 1; ++i) {
            if (comparator.compare(keys[i], keys[i + 1]) < 0) continue;
            return false;
        }
        return true;
    }

    static boolean containsNull(AnyValue[] values) {
        for (AnyValue value : values) {
            if (value != null) continue;
            return true;
        }
        return false;
    }

    static boolean containsNull(List<AnyValue> values) {
        for (AnyValue value : values) {
            if (value != null) continue;
            return true;
        }
        return false;
    }

    static <T> Iterator<T> asIterator(final T[] array) {
        assert (array != null);
        return new Iterator<T>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < array.length;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return array[this.index++];
            }
        };
    }
}

