/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.virtual;

import com.mware.ge.Authorizations;
import com.mware.ge.values.AnyValue;
import com.mware.ge.values.AnyValueWriter;
import com.mware.ge.values.ValueMapper;
import com.mware.ge.values.VirtualValue;
import com.mware.ge.values.virtual.ListValue;
import com.mware.ge.values.virtual.NodeValue;
import com.mware.ge.values.virtual.RelationshipValue;
import com.mware.ge.values.virtual.VirtualValueGroup;
import com.mware.ge.values.virtual.VirtualValues;
import java.util.Arrays;
import java.util.Comparator;

public abstract class PathValue
extends VirtualValue {
    public abstract NodeValue startNode();

    public abstract NodeValue endNode();

    public abstract RelationshipValue lastRelationship();

    public abstract NodeValue[] nodes();

    public abstract RelationshipValue[] relationships();

    @Override
    public boolean equals(VirtualValue other) {
        if (other == null || !(other instanceof PathValue)) {
            return false;
        }
        PathValue that = (PathValue)other;
        return this.size() == that.size() && Arrays.equals(this.nodes(), that.nodes()) && Arrays.equals(this.relationships(), that.relationships());
    }

    @Override
    public int computeHash() {
        NodeValue[] nodes = this.nodes();
        RelationshipValue[] relationships = this.relationships();
        int result = nodes[0].hashCode();
        for (int i = 1; i < nodes.length; ++i) {
            result += 31 * (result + relationships[i - 1].hashCode());
            result += 31 * (result + nodes[i].hashCode());
        }
        return result;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer, Authorizations authorizations) throws E {
        writer.writePath(this.nodes(), this.relationships(), authorizations);
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapPath(this);
    }

    @Override
    public VirtualValueGroup valueGroup() {
        return VirtualValueGroup.PATH;
    }

    @Override
    public int compareTo(VirtualValue other, Comparator<AnyValue> comparator) {
        if (other == null || !(other instanceof PathValue)) {
            throw new IllegalArgumentException("Cannot compare different virtual values");
        }
        PathValue otherPath = (PathValue)other;
        NodeValue[] nodes = this.nodes();
        RelationshipValue[] relationships = this.relationships();
        NodeValue[] otherNodes = otherPath.nodes();
        RelationshipValue[] otherRelationships = otherPath.relationships();
        int x = nodes[0].compareTo(otherNodes[0], comparator);
        if (x == 0) {
            int length = Math.min(relationships.length, otherRelationships.length);
            for (int i = 0; x == 0 && i < length; ++i) {
                x = relationships[i].compareTo(otherRelationships[i], comparator);
            }
            if (x == 0) {
                x = Integer.compare(relationships.length, otherRelationships.length);
            }
        }
        return x;
    }

    public String toString() {
        int i;
        NodeValue[] nodes = this.nodes();
        RelationshipValue[] relationships = this.relationships();
        StringBuilder sb = new StringBuilder(this.getTypeName() + "{");
        for (i = 0; i < relationships.length; ++i) {
            sb.append(nodes[i]);
            sb.append(relationships[i]);
        }
        sb.append(nodes[i]);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String getTypeName() {
        return "Path";
    }

    public ListValue asList() {
        NodeValue[] nodes = this.nodes();
        RelationshipValue[] relationships = this.relationships();
        int size = nodes.length + relationships.length;
        AnyValue[] anyValues = new AnyValue[size];
        for (int i = 0; i < size; ++i) {
            anyValues[i] = i % 2 == 0 ? nodes[i / 2] : relationships[i / 2];
        }
        return VirtualValues.list(anyValues);
    }

    public int size() {
        return this.relationships().length;
    }

    public static class DirectPathValue
    extends PathValue {
        private final NodeValue[] nodes;
        private final RelationshipValue[] edges;

        DirectPathValue(NodeValue[] nodes, RelationshipValue[] edges) {
            assert (nodes != null);
            assert (edges != null);
            assert (nodes.length == edges.length + 1);
            this.nodes = nodes;
            this.edges = edges;
        }

        @Override
        public NodeValue startNode() {
            return this.nodes[0];
        }

        @Override
        public NodeValue endNode() {
            return this.nodes[this.nodes.length - 1];
        }

        @Override
        public RelationshipValue lastRelationship() {
            assert (this.edges.length > 0);
            return this.edges[this.edges.length - 1];
        }

        @Override
        public NodeValue[] nodes() {
            return this.nodes;
        }

        @Override
        public RelationshipValue[] relationships() {
            return this.edges;
        }

        @Override
        public String toString() {
            return this.startNode() + "---" + this.endNode();
        }
    }
}

