/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.virtual;

import com.mware.ge.Authorizations;
import com.mware.ge.values.AnyValueWriter;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.virtual.MapValue;
import com.mware.ge.values.virtual.NodeValue;
import com.mware.ge.values.virtual.VirtualNodeValue;
import com.mware.ge.values.virtual.VirtualRelationshipValue;

public abstract class RelationshipValue
extends VirtualRelationshipValue {
    private final String id;

    protected RelationshipValue(String id) {
        this.id = id;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer, Authorizations authorizations) throws E {
        writer.writeRelationship(this.id, this.startNodeId(), this.endNodeId(), this.type(), this.properties(), authorizations);
    }

    public String toString() {
        return String.format("-[%s]-", this.id);
    }

    public abstract NodeValue startNode();

    public String startNodeId() {
        return this.startNode().id();
    }

    public abstract NodeValue endNode();

    public String endNodeId() {
        return this.endNode().id();
    }

    @Override
    public String id() {
        return this.id;
    }

    public abstract TextValue type();

    public abstract MapValue properties();

    public NodeValue otherNode(VirtualNodeValue node) {
        return node.equals(this.startNode()) ? this.endNode() : this.startNode();
    }

    public String otherNodeId(String node) {
        return node.equals(this.startNodeId()) ? this.endNodeId() : this.startNodeId();
    }

    @Override
    public String getTypeName() {
        return "Relationship";
    }

    static class DirectRelationshipValue
    extends RelationshipValue {
        private final NodeValue startNode;
        private final NodeValue endNode;
        private final TextValue type;
        private final MapValue properties;

        DirectRelationshipValue(String id, NodeValue startNode, NodeValue endNode, TextValue type, MapValue properties) {
            super(id);
            assert (properties != null);
            this.startNode = startNode;
            this.endNode = endNode;
            this.type = type;
            this.properties = properties;
        }

        @Override
        public NodeValue startNode() {
            return this.startNode;
        }

        @Override
        public NodeValue endNode() {
            return this.endNode;
        }

        @Override
        public TextValue type() {
            return this.type;
        }

        @Override
        public MapValue properties() {
            return this.properties;
        }
    }
}

