/*
 * Decompiled with CFR 0.152.
 */
package com.mware.ge.values.virtual;

import com.mware.ge.values.AnyValue;
import com.mware.ge.values.storable.ArrayValue;
import com.mware.ge.values.storable.TextArray;
import com.mware.ge.values.storable.TextValue;
import com.mware.ge.values.virtual.ErrorValue;
import com.mware.ge.values.virtual.ListValue;
import com.mware.ge.values.virtual.MapValue;
import com.mware.ge.values.virtual.NodeReference;
import com.mware.ge.values.virtual.NodeValue;
import com.mware.ge.values.virtual.PathValue;
import com.mware.ge.values.virtual.RelationshipReference;
import com.mware.ge.values.virtual.RelationshipValue;
import java.util.HashMap;
import java.util.List;

public final class VirtualValues {
    public static final MapValue EMPTY_MAP = MapValue.EMPTY;
    public static final ListValue EMPTY_LIST = new ListValue.ArrayListValue(new AnyValue[0]);

    private VirtualValues() {
    }

    public static ListValue list(AnyValue ... values) {
        return new ListValue.ArrayListValue(values);
    }

    public static ListValue fromList(List<AnyValue> values) {
        return new ListValue.JavaListListValue(values);
    }

    public static ListValue range(long start, long end, long step) {
        return new ListValue.IntegralRangeListValue(start, end, step);
    }

    public static ListValue fromArray(ArrayValue arrayValue) {
        return new ListValue.ArrayValueListValue(arrayValue);
    }

    public static ListValue concat(ListValue ... lists) {
        return new ListValue.ConcatList(lists);
    }

    public static MapValue emptyMap() {
        return EMPTY_MAP;
    }

    public static MapValue map(String[] keys, AnyValue[] values) {
        assert (keys.length == values.length);
        HashMap<String, AnyValue> map = new HashMap<String, AnyValue>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return new MapValue.MapWrappingMapValue(map);
    }

    public static ErrorValue error(Exception e) {
        return new ErrorValue(e);
    }

    public static NodeReference node(String id) {
        return new NodeReference(id);
    }

    public static RelationshipReference relationship(String id) {
        return new RelationshipReference(id);
    }

    public static PathValue path(NodeValue[] nodes, RelationshipValue[] relationships) {
        assert (nodes != null);
        assert (relationships != null);
        if ((nodes.length + relationships.length) % 2 == 0) {
            throw new IllegalArgumentException("Tried to construct a path that is not built like a path: even number of elements");
        }
        return new PathValue.DirectPathValue(nodes, relationships);
    }

    public static NodeValue nodeValue(String id, TextArray labels, MapValue properties) {
        return new NodeValue.DirectNodeValue(id, labels, properties);
    }

    public static RelationshipValue relationshipValue(String id, NodeValue startNode, NodeValue endNode, TextValue type, MapValue properties) {
        return new RelationshipValue.DirectRelationshipValue(id, startNode, endNode, type, properties);
    }
}

