/*
 * Decompiled with CFR 0.152.
 */
package com.mware.kryo.kryo.serializers;

import com.mware.kryo.kryo.Kryo;
import com.mware.kryo.kryo.KryoException;
import com.mware.kryo.kryo.Serializer;
import com.mware.kryo.kryo.io.Input;
import com.mware.kryo.kryo.io.Output;

public class EnumNameSerializer
extends Serializer<Enum> {
    private final Class<? extends Enum> enumType;
    private final Serializer stringSerializer;

    public EnumNameSerializer(Kryo kryo, Class<? extends Enum> type) {
        this.enumType = type;
        this.stringSerializer = kryo.getSerializer(String.class);
        this.setImmutable(true);
    }

    @Override
    public void write(Kryo kryo, Output output, Enum object) {
        kryo.writeObject(output, object.name(), this.stringSerializer);
    }

    @Override
    public Enum read(Kryo kryo, Input input, Class<Enum> type) {
        String name = kryo.readObject(input, String.class, this.stringSerializer);
        try {
            return Enum.valueOf(this.enumType, name);
        }
        catch (IllegalArgumentException e) {
            throw new KryoException("Invalid name for enum \"" + this.enumType.getName() + "\": " + name, e);
        }
    }
}

