/*
 * Decompiled with CFR 0.152.
 */
package com.mware.kryo.kryo.serializers;

import com.mware.kryo.kryo.Kryo;
import com.mware.kryo.kryo.Serializer;
import com.mware.kryo.kryo.io.Input;
import com.mware.kryo.kryo.io.Output;
import com.mware.kryo.kryo.util.Util;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class TimeSerializers {
    public static void addDefaultSerializers(Kryo kryo) {
        if (Util.isClassAvailable("java.time.Duration")) {
            kryo.addDefaultSerializer(Duration.class, new DurationSerializer());
        }
        if (Util.isClassAvailable("java.time.Instant")) {
            kryo.addDefaultSerializer(Instant.class, new InstantSerializer());
        }
        if (Util.isClassAvailable("java.time.LocalDate")) {
            kryo.addDefaultSerializer(LocalDate.class, new LocalDateSerializer());
        }
        if (Util.isClassAvailable("java.time.LocalTime")) {
            kryo.addDefaultSerializer(LocalTime.class, new LocalTimeSerializer());
        }
        if (Util.isClassAvailable("java.time.LocalDateTime")) {
            kryo.addDefaultSerializer(LocalDateTime.class, new LocalDateTimeSerializer());
        }
        if (Util.isClassAvailable("java.time.ZoneOffset")) {
            kryo.addDefaultSerializer(ZoneOffset.class, new ZoneOffsetSerializer());
        }
        if (Util.isClassAvailable("java.time.ZoneId")) {
            kryo.addDefaultSerializer(ZoneId.class, new ZoneIdSerializer());
        }
        if (Util.isClassAvailable("java.time.OffsetTime")) {
            kryo.addDefaultSerializer(OffsetTime.class, new OffsetTimeSerializer());
        }
        if (Util.isClassAvailable("java.time.OffsetDateTime")) {
            kryo.addDefaultSerializer(OffsetDateTime.class, new OffsetDateTimeSerializer());
        }
        if (Util.isClassAvailable("java.time.ZonedDateTime")) {
            kryo.addDefaultSerializer(ZonedDateTime.class, new ZonedDateTimeSerializer());
        }
        if (Util.isClassAvailable("java.time.Year")) {
            kryo.addDefaultSerializer(Year.class, new YearSerializer());
        }
        if (Util.isClassAvailable("java.time.YearMonth")) {
            kryo.addDefaultSerializer(YearMonth.class, new YearMonthSerializer());
        }
        if (Util.isClassAvailable("java.time.MonthDay")) {
            kryo.addDefaultSerializer(MonthDay.class, new MonthDaySerializer());
        }
        if (Util.isClassAvailable("java.time.Period")) {
            kryo.addDefaultSerializer(Period.class, new PeriodSerializer());
        }
    }

    private static class PeriodSerializer
    extends Serializer<Period> {
        private PeriodSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output out, Period obj) {
            out.writeInt(obj.getYears(), true);
            out.writeInt(obj.getMonths(), true);
            out.writeInt(obj.getDays(), true);
        }

        @Override
        public Period read(Kryo kryo, Input in, Class<Period> type) {
            int years = in.readInt(true);
            int months = in.readInt(true);
            int days = in.readInt(true);
            return Period.of(years, months, days);
        }
    }

    private static class MonthDaySerializer
    extends Serializer<MonthDay> {
        private MonthDaySerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output out, MonthDay obj) {
            out.writeByte(obj.getMonthValue());
            out.writeByte(obj.getDayOfMonth());
        }

        @Override
        public MonthDay read(Kryo kryo, Input in, Class<MonthDay> type) {
            byte month = in.readByte();
            byte day = in.readByte();
            return MonthDay.of(month, (int)day);
        }
    }

    private static class YearMonthSerializer
    extends Serializer<YearMonth> {
        private YearMonthSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output out, YearMonth obj) {
            out.writeInt(obj.getYear(), true);
            out.writeByte(obj.getMonthValue());
        }

        @Override
        public YearMonth read(Kryo kryo, Input in, Class<YearMonth> type) {
            int year = in.readInt(true);
            byte month = in.readByte();
            return YearMonth.of(year, month);
        }
    }

    private static class YearSerializer
    extends Serializer<Year> {
        private YearSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output out, Year obj) {
            out.writeInt(obj.getValue(), true);
        }

        @Override
        public Year read(Kryo kryo, Input in, Class<Year> type) {
            return Year.of(in.readInt(true));
        }
    }

    private static class ZonedDateTimeSerializer
    extends Serializer<ZonedDateTime> {
        private ZonedDateTimeSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output out, ZonedDateTime obj) {
            LocalDateSerializer.write(out, obj.toLocalDate());
            LocalTimeSerializer.write(out, obj.toLocalTime());
            ZoneIdSerializer.write(out, obj.getZone());
        }

        @Override
        public ZonedDateTime read(Kryo kryo, Input in, Class<ZonedDateTime> type) {
            LocalDate date = LocalDateSerializer.read(in);
            LocalTime time = LocalTimeSerializer.read(in);
            ZoneId zone = ZoneIdSerializer.read(in);
            return ZonedDateTime.of(date, time, zone);
        }
    }

    private static class OffsetDateTimeSerializer
    extends Serializer<OffsetDateTime> {
        private OffsetDateTimeSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output out, OffsetDateTime obj) {
            LocalDateSerializer.write(out, obj.toLocalDate());
            LocalTimeSerializer.write(out, obj.toLocalTime());
            ZoneOffsetSerializer.write(out, obj.getOffset());
        }

        @Override
        public OffsetDateTime read(Kryo kryo, Input in, Class<OffsetDateTime> type) {
            LocalDate date = LocalDateSerializer.read(in);
            LocalTime time = LocalTimeSerializer.read(in);
            ZoneOffset offset = ZoneOffsetSerializer.read(in);
            return OffsetDateTime.of(date, time, offset);
        }
    }

    private static class OffsetTimeSerializer
    extends Serializer<OffsetTime> {
        private OffsetTimeSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output out, OffsetTime obj) {
            LocalTimeSerializer.write(out, obj.toLocalTime());
            ZoneOffsetSerializer.write(out, obj.getOffset());
        }

        @Override
        public OffsetTime read(Kryo kryo, Input in, Class<OffsetTime> type) {
            LocalTime time = LocalTimeSerializer.read(in);
            ZoneOffset offset = ZoneOffsetSerializer.read(in);
            return OffsetTime.of(time, offset);
        }
    }

    private static class ZoneIdSerializer
    extends Serializer<ZoneId> {
        private ZoneIdSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output out, ZoneId obj) {
            ZoneIdSerializer.write(out, obj);
        }

        static void write(Output out, ZoneId obj) {
            out.writeString(obj.getId());
        }

        @Override
        public ZoneId read(Kryo kryo, Input in, Class<ZoneId> type) {
            return ZoneIdSerializer.read(in);
        }

        static ZoneId read(Input in) {
            String id = in.readString();
            return ZoneId.of(id);
        }
    }

    private static class ZoneOffsetSerializer
    extends Serializer<ZoneOffset> {
        private ZoneOffsetSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output out, ZoneOffset obj) {
            ZoneOffsetSerializer.write(out, obj);
        }

        static void write(Output out, ZoneOffset obj) {
            int offsetSecs = obj.getTotalSeconds();
            int offsetByte = offsetSecs % 900 == 0 ? offsetSecs / 900 : 127;
            out.writeByte(offsetByte);
            if (offsetByte == 127) {
                out.writeInt(offsetSecs);
            }
        }

        @Override
        public ZoneOffset read(Kryo kryo, Input in, Class<ZoneOffset> type) {
            return ZoneOffsetSerializer.read(in);
        }

        static ZoneOffset read(Input in) {
            byte offsetByte = in.readByte();
            return offsetByte == 127 ? ZoneOffset.ofTotalSeconds(in.readInt()) : ZoneOffset.ofTotalSeconds(offsetByte * 900);
        }
    }

    private static class LocalTimeSerializer
    extends Serializer<LocalTime> {
        private LocalTimeSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output out, LocalTime time) {
            LocalTimeSerializer.write(out, time);
        }

        static void write(Output out, LocalTime time) {
            if (time.getNano() == 0) {
                if (time.getSecond() == 0) {
                    if (time.getMinute() == 0) {
                        out.writeByte(~time.getHour());
                    } else {
                        out.writeByte(time.getHour());
                        out.writeByte(~time.getMinute());
                    }
                } else {
                    out.writeByte(time.getHour());
                    out.writeByte(time.getMinute());
                    out.writeByte(~time.getSecond());
                }
            } else {
                out.writeByte(time.getHour());
                out.writeByte(time.getMinute());
                out.writeByte(time.getSecond());
                out.writeInt(time.getNano(), true);
            }
        }

        @Override
        public LocalTime read(Kryo kryo, Input in, Class<LocalTime> type) {
            return LocalTimeSerializer.read(in);
        }

        static LocalTime read(Input in) {
            int hour = in.readByte();
            int minute = 0;
            int second = 0;
            int nano = 0;
            if (hour < 0) {
                hour ^= 0xFFFFFFFF;
            } else {
                minute = in.readByte();
                if (minute < 0) {
                    minute ^= 0xFFFFFFFF;
                } else {
                    second = in.readByte();
                    if (second < 0) {
                        second ^= 0xFFFFFFFF;
                    } else {
                        nano = in.readInt(true);
                    }
                }
            }
            return LocalTime.of(hour, minute, second, nano);
        }
    }

    private static class LocalDateTimeSerializer
    extends Serializer<LocalDateTime> {
        private LocalDateTimeSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output out, LocalDateTime dateTime) {
            LocalDateSerializer.write(out, dateTime.toLocalDate());
            LocalTimeSerializer.write(out, dateTime.toLocalTime());
        }

        @Override
        public LocalDateTime read(Kryo kryo, Input in, Class<LocalDateTime> type) {
            LocalDate date = LocalDateSerializer.read(in);
            LocalTime time = LocalTimeSerializer.read(in);
            return LocalDateTime.of(date, time);
        }
    }

    private static class LocalDateSerializer
    extends Serializer<LocalDate> {
        private LocalDateSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output out, LocalDate date) {
            LocalDateSerializer.write(out, date);
        }

        static void write(Output out, LocalDate date) {
            out.writeInt(date.getYear(), true);
            out.writeByte(date.getMonthValue());
            out.writeByte(date.getDayOfMonth());
        }

        @Override
        public LocalDate read(Kryo kryo, Input in, Class<LocalDate> type) {
            return LocalDateSerializer.read(in);
        }

        static LocalDate read(Input in) {
            int year = in.readInt(true);
            byte month = in.readByte();
            byte dayOfMonth = in.readByte();
            return LocalDate.of(year, month, (int)dayOfMonth);
        }
    }

    private static class InstantSerializer
    extends Serializer<Instant> {
        private InstantSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output out, Instant instant) {
            out.writeLong(instant.getEpochSecond(), true);
            out.writeInt(instant.getNano(), true);
        }

        @Override
        public Instant read(Kryo kryo, Input in, Class<Instant> type) {
            long seconds = in.readLong(true);
            int nanos = in.readInt(true);
            return Instant.ofEpochSecond(seconds, nanos);
        }
    }

    private static class DurationSerializer
    extends Serializer<Duration> {
        private DurationSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output out, Duration duration) {
            out.writeLong(duration.getSeconds());
            out.writeInt(duration.getNano(), true);
        }

        @Override
        public Duration read(Kryo kryo, Input in, Class<Duration> type) {
            long seconds = in.readLong();
            int nanos = in.readInt(true);
            return Duration.ofSeconds(seconds, nanos);
        }
    }
}

