/*
 * Copyright (c) 2020 Connor Goulding
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.bindingz.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class SourceResource {

    private final ContractDto content;
    private final List<SourceDto> sources;

    @JsonCreator
    public SourceResource(@JsonProperty("content") ContractDto content,
                          @JsonProperty("sources") List<SourceDto> sources) {
        this.content = content;
        this.sources = sources;
    }

    public ContractDto getContent() {
        return content;
    }

    public List<SourceDto> getSources() {
        return sources;
    }
}
