/*
 */
package org.vfd.strapi;

import java.util.List;
import org.vfd.strapi.enums.HttpMethod;
import org.vfd.strapi.enums.ResponseMessage;
import org.vfd.strapi.interfaces.CollectionInterface;
import org.vfd.strapi.models.Response;
import org.vfd.strapi.models.StrapiArrayResponse;
import org.vfd.strapi.models.StrapiMonoResponse;
import org.vfd.strapi.parameters.PageRequest;
import org.vfd.strapi.parameters.SortRequest;

/**
 *
 * @author Ayomide.Oyediran
 */
public class Collection implements CollectionInterface {

    final Transporter config;

    Collection(Transporter config) {
        this.config = config;
    }

    @Override
    public <T> Response<StrapiArrayResponse<T>> getAll(String pluralId,
            Class<T> modelClass, PageRequest pagination, List<SortRequest> sorting, String... rawQuery) {
        config.setCurrentEndpoint(pluralId);
        config.setMethod(HttpMethod.GET);
        config.setSorting(sorting);
        config.setPagination(pagination);
        config.setRawQuery(rawQuery);
        Response res = Connector.connect(config, StrapiArrayResponse.class);
        if (!res.getHasError()) {
            res.setMessage(ResponseMessage.DATA_FETCHED.text);
        }
        return res;
    }

    @Override
    public <T> Response<StrapiArrayResponse<T>> save(String pluralId, T payload, Class<T> rClass, String... rawQuery) {
        config.setCurrentEndpoint(pluralId);
        config.setMethod(HttpMethod.POST);
        config.setPayload(payload);
        config.setSorting(null);
        config.setPagination(null);
        config.setRawQuery(rawQuery);
        Response res = Connector.connect(config, StrapiArrayResponse.class);
        if (!res.getHasError()) {
            res.setMessage(ResponseMessage.SAVED.text);
        }
        return res;
    }

    @Override
    public <T> Response<StrapiMonoResponse<T>> getOne(String pluralId, long documentId, Class<T> rClass, String... rawQuery) {
        config.setCurrentEndpoint(pluralId+"/"+documentId);
        config.setMethod(HttpMethod.GET);
        config.setSorting(null);
        config.setPagination(null);
        config.setRawQuery(rawQuery);
        Response res = Connector.connect(config, StrapiMonoResponse.class);
        if (!res.getHasError()) {
            res.setMessage(ResponseMessage.DATA_FETCHED.text);
        }
        return res;
    }

    @Override
    public <T> Response<StrapiMonoResponse<T>> update(String pluralId, long documentId, T payload, Class<T> rClass, String... rawQuery) {
        config.setCurrentEndpoint(pluralId+"/"+documentId);
        config.setMethod(HttpMethod.PUT);
        config.setPayload(payload);
        config.setSorting(null);
        config.setPagination(null);
        config.setRawQuery(rawQuery);
        Response res = Connector.connect(config, StrapiMonoResponse.class);
        if (!res.getHasError()) {
            res.setMessage(ResponseMessage.UPDATED.text);
        }
        return res;
    }

    @Override
    public <T> Response<StrapiMonoResponse<T>> delete(String pluralId, long documentId, Class<T> rClass, String... rawQuery) {
        config.setCurrentEndpoint(pluralId+"/"+documentId);
        config.setMethod(HttpMethod.DELETE);
        config.setSorting(null);
        config.setPagination(null);
        config.setRawQuery(rawQuery);
        Response res = Connector.connect(config, StrapiMonoResponse.class);
        if (!res.getHasError()) {
            res.setMessage(ResponseMessage.DELETE.text);
        }
        return res;
    }
}
