/*
 */
package org.vfd.strapi;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.io.IOException;
import org.vfd.strapi.enums.HttpMethod;
import org.vfd.strapi.models.Response;
import org.vfd.strapi.models.StrapiError;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.vfd.strapi.exceptions.CustomException;
/**
 *
 * @author Ayomide.Oyediran
 */
public class Connector {

    public static <T> Response<T> connect(Transporter trans, Class<T> bodyClass) {
        StrapiError errObj = new StrapiError();
        try {
            String stringnifyPayload = "";
            if ((trans.getMethod() != HttpMethod.GET) && (trans.getMethod() != HttpMethod.DELETE)) {
                Map payload = new HashMap();
                payload.put("data", trans.getPayload());
                stringnifyPayload = Helper.MAPPER.writeValueAsString(payload);
            }
            String api = trans.getBaseUrl() + "/api/" + trans.getCurrentEndpoint() + "?";

            if (trans.getPagination() != null) {
                api += Helper.buildPaginationQuery(trans.getPagination());
            }
            if (trans.getSorting() != null) {
                api += Helper.buildSortingQuery(trans.getSorting());
            }
            if (trans.getPopulateAllField()) {
                api+="&populate=%2A";
            }
            api += Helper.buildRawQuery(trans.getRawQuery());
            OkHttpClient client = new OkHttpClient();
            Request req = new Request.Builder()
                    .url(api)
                    .header("authorization", "Bearer " + trans.getApiKey())
                    .build();
            if (trans.getMethod() == HttpMethod.POST || trans.getMethod() == HttpMethod.PUT) {
                req.newBuilder()
                        .method(
                                trans.getMethod().text,
                                RequestBody.create(MediaType.parse("application/json"), stringnifyPayload)
                        )
                        .build();
            } else {
                req.newBuilder().method(trans.getMethod().text, null);
            }
            com.squareup.okhttp.Response res = client.newCall(req).execute();
            Object responsePayload = Helper.MAPPER.readValue(res.body().byteStream(), Object.class);

            if (res.isSuccessful()) {
                T resBody = Helper.MAPPER.convertValue(responsePayload, bodyClass);
                Response<T> clientRes = new Response(
                        res.code(),
                        !res.isSuccessful(),
                        (T) resBody
                );
                return clientRes;
            }
            // Something went wrong
            HashMap rBody = Helper.MAPPER.convertValue(responsePayload, HashMap.class);
            errObj = Helper.MAPPER.convertValue(rBody.get("error"), StrapiError.class);
            throw new CustomException(errObj.getMessage(), errObj.getStatus(), errObj.getDetails());
        } catch (CustomException ce) {
            throw ce;
        }catch (IOException | IllegalArgumentException ex) {
            errObj.setMessage(ex.getMessage());
            Logger.getLogger(Connector.class.getName()).log(Level.SEVERE, null, ex);
        }
        return new Response(errObj.getMessage(), errObj.getStatus(), Boolean.TRUE, null);
    }
}
