/*
 */
package org.vfd.strapi;

import org.vfd.strapi.enums.HttpMethod;
import org.vfd.strapi.enums.ResponseMessage;
import org.vfd.strapi.interfaces.SingularInterface;
import org.vfd.strapi.models.Response;
import org.vfd.strapi.models.StrapiData;
import org.vfd.strapi.models.StrapiMonoResponse;

/**
 *
 * @author Ayomide.Oyediran
 */
public class Singular implements SingularInterface{
    private final Transporter config;
    
    public Singular(Transporter config) {
        this.config = config;
    }

    @Override
    public <T> Response<StrapiMonoResponse<T>> get(String singularApiId, Class<T> rClass, String... rawQuery) {
        config.setCurrentEndpoint(singularApiId);
        config.setMethod(HttpMethod.GET);
        config.setSorting(null);
        config.setPagination(null);
        config.setRawQuery(rawQuery);
        Response res = Connector.connect(config, StrapiMonoResponse.class);
        if (!res.getHasError()) {
            res.setMessage(ResponseMessage.DATA_FETCHED.text);
        }
        return res;
    }

    @Override
    public <T> Response<StrapiMonoResponse<T>> update(String singularApiId, T payload, Class<T> rClass, String... rawQuery) {
        config.setCurrentEndpoint(singularApiId);
        config.setMethod(HttpMethod.PUT);
        config.setPayload(payload);
        config.setSorting(null);
        config.setPagination(null);
        config.setRawQuery(rawQuery);
        Response res = Connector.connect(config, StrapiMonoResponse.class);
        if (!res.getHasError()) {
            res.setMessage(ResponseMessage.UPDATED.text);
        }
        return res;
    }

    @Override
    public <T> Response<StrapiMonoResponse<T>> delete(String singularApiId, Class<T> rClass, String... rawQuery) {
        config.setCurrentEndpoint(singularApiId);
        config.setMethod(HttpMethod.DELETE);
        config.setSorting(null);
        config.setPagination(null);
        config.setRawQuery(rawQuery);
        Response res = Connector.connect(config, StrapiMonoResponse.class);
        if (!res.getHasError()) {
            res.setMessage(ResponseMessage.DELETE.text);
        }
        return res;
    }
}
