/*
 */
package org.vfd.strapi;

import java.util.List;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.vfd.strapi.enums.HttpMethod;
import org.vfd.strapi.parameters.PageRequest;
import org.vfd.strapi.parameters.SortRequest;

/**
 *
 * @author Ayomide.Oyediran
 */
@Getter
@Setter
@NoArgsConstructor
public class Transporter {
    private String apiKey;
    private String baseUrl;
    private Boolean populateAllField;
    private String currentEndpoint;
    private HttpMethod method;
    private Object payload;
    private PageRequest pagination;
    private List<SortRequest> sorting;
    private String[] rawQuery;
    
    public Transporter(String apiKey, String strapiUrl, Boolean populateAllField) {
        this.apiKey = apiKey;
        this.baseUrl = strapiUrl;
        this.populateAllField = populateAllField;
    }

}
