/*
 */
package org.vfd.strapi.interfaces;

import java.util.List;
import org.vfd.strapi.models.Response;
import org.vfd.strapi.models.StrapiArrayResponse;
import org.vfd.strapi.models.StrapiMonoResponse;
import org.vfd.strapi.parameters.PageRequest;
import org.vfd.strapi.parameters.SortRequest;

/**
 *
 * @author Ayomide.Oyediran
 */
public interface CollectionInterface {
    <T> Response<StrapiArrayResponse<T>> getAll(String pluraId, Class<T> rClass,
            PageRequest pagination, List<SortRequest> sorting, String... rawQuery);
    <T> Response<StrapiArrayResponse<T>> save(String pluralId, T payload, Class<T> rClass, String... rawQuery);
    <T> Response<StrapiMonoResponse<T>> getOne(String pluralId, long documentId, Class<T> rClass, String... rawQuery);
    <T> Response<StrapiMonoResponse<T>> update(String pluralId, long documentId, T payload, Class<T> rClass, String... rawQuery);
    <T> Response<StrapiMonoResponse<T>> delete(String pluralId, long documentId, Class<T> rClass, String... rawQuery);
}
