package org.vfd.strapi.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.HashMap;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Setter
@Getter
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class FileAttribute {
    private String name;
    private String alternativeText;
    private String caption;
    private double width;
    private double height;
    private HashMap formats;
    private String hash;
    private String ext;
    private String mime;
    private String url;
    private double size;
    private String previewUrl;
    private String provider;
    private Object provider_metadata;
    private String createdAt;
    private String updatedAt;
}
