/*
 * Decompiled with CFR 0.152.
 */
package org.vfd.strapi;

import java.util.List;
import org.vfd.strapi.Connector;
import org.vfd.strapi.Transporter;
import org.vfd.strapi.enums.HttpMethod;
import org.vfd.strapi.enums.ResponseMessage;
import org.vfd.strapi.interfaces.CollectionInterface;
import org.vfd.strapi.models.Response;
import org.vfd.strapi.models.StrapiArrayResponse;
import org.vfd.strapi.models.StrapiMonoResponse;
import org.vfd.strapi.parameters.PageRequest;
import org.vfd.strapi.parameters.SortRequest;

public class Collection
implements CollectionInterface {
    final Transporter config;

    Collection(Transporter config) {
        this.config = config;
    }

    @Override
    public <T> Response<StrapiArrayResponse<T>> getAll(String pluralId, Class<T> modelClass, PageRequest pagination, List<SortRequest> sorting, String ... rawQuery) {
        this.config.setCurrentEndpoint(pluralId);
        this.config.setMethod(HttpMethod.GET);
        this.config.setSorting(sorting);
        this.config.setPagination(pagination);
        this.config.setRawQuery(rawQuery);
        Response<StrapiArrayResponse<T>> res = Connector.connect(this.config, StrapiArrayResponse.class);
        if (!res.getHasError().booleanValue()) {
            res.setMessage(ResponseMessage.DATA_FETCHED.text);
        }
        return res;
    }

    @Override
    public <T> Response<StrapiArrayResponse<T>> save(String pluralId, T payload, Class<T> rClass, String ... rawQuery) {
        this.config.setCurrentEndpoint(pluralId);
        this.config.setMethod(HttpMethod.POST);
        this.config.setPayload(payload);
        this.config.setSorting(null);
        this.config.setPagination(null);
        this.config.setRawQuery(rawQuery);
        Response<StrapiArrayResponse<T>> res = Connector.connect(this.config, StrapiArrayResponse.class);
        if (!res.getHasError().booleanValue()) {
            res.setMessage(ResponseMessage.SAVED.text);
        }
        return res;
    }

    @Override
    public <T> Response<StrapiMonoResponse<T>> getOne(String pluralId, long documentId, Class<T> rClass, String ... rawQuery) {
        this.config.setCurrentEndpoint(pluralId + "/" + documentId);
        this.config.setMethod(HttpMethod.GET);
        this.config.setSorting(null);
        this.config.setPagination(null);
        this.config.setRawQuery(rawQuery);
        Response<StrapiMonoResponse<T>> res = Connector.connect(this.config, StrapiMonoResponse.class);
        if (!res.getHasError().booleanValue()) {
            res.setMessage(ResponseMessage.DATA_FETCHED.text);
        }
        return res;
    }

    @Override
    public <T> Response<StrapiMonoResponse<T>> update(String pluralId, long documentId, T payload, Class<T> rClass, String ... rawQuery) {
        this.config.setCurrentEndpoint(pluralId + "/" + documentId);
        this.config.setMethod(HttpMethod.PUT);
        this.config.setPayload(payload);
        this.config.setSorting(null);
        this.config.setPagination(null);
        this.config.setRawQuery(rawQuery);
        Response<StrapiMonoResponse<T>> res = Connector.connect(this.config, StrapiMonoResponse.class);
        if (!res.getHasError().booleanValue()) {
            res.setMessage(ResponseMessage.UPDATED.text);
        }
        return res;
    }

    @Override
    public <T> Response<StrapiMonoResponse<T>> delete(String pluralId, long documentId, Class<T> rClass, String ... rawQuery) {
        this.config.setCurrentEndpoint(pluralId + "/" + documentId);
        this.config.setMethod(HttpMethod.DELETE);
        this.config.setSorting(null);
        this.config.setPagination(null);
        this.config.setRawQuery(rawQuery);
        Response<StrapiMonoResponse<T>> res = Connector.connect(this.config, StrapiMonoResponse.class);
        if (!res.getHasError().booleanValue()) {
            res.setMessage(ResponseMessage.DELETE.text);
        }
        return res;
    }
}

