/*
 * Decompiled with CFR 0.152.
 */
package org.vfd.strapi;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.vfd.strapi.Helper;
import org.vfd.strapi.Transporter;
import org.vfd.strapi.enums.HttpMethod;
import org.vfd.strapi.exceptions.CustomException;
import org.vfd.strapi.models.Response;
import org.vfd.strapi.models.StrapiError;

public class Connector {
    public static <T> Response<T> connect(Transporter trans, Class<T> bodyClass) {
        StrapiError errObj = new StrapiError();
        try {
            String stringnifyPayload = "";
            if (trans.getMethod() != HttpMethod.GET && trans.getMethod() != HttpMethod.DELETE) {
                HashMap<String, Object> payload = new HashMap<String, Object>();
                payload.put("data", trans.getPayload());
                stringnifyPayload = Helper.MAPPER.writeValueAsString(payload);
            }
            String api = trans.getBaseUrl() + "/api/" + trans.getCurrentEndpoint() + "?";
            if (trans.getPagination() != null) {
                api = api + Helper.buildPaginationQuery(trans.getPagination());
            }
            if (trans.getSorting() != null) {
                api = api + Helper.buildSortingQuery(trans.getSorting());
            }
            if (trans.getPopulateAllField().booleanValue()) {
                api = api + "&populate=%2A";
            }
            api = api + Helper.buildRawQuery(trans.getRawQuery());
            OkHttpClient client = new OkHttpClient();
            Request req = new Request.Builder().url(api).header("authorization", "Bearer " + trans.getApiKey()).build();
            if (trans.getMethod() == HttpMethod.POST || trans.getMethod() == HttpMethod.PUT) {
                req.newBuilder().method(trans.getMethod().text, RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)stringnifyPayload)).build();
            } else {
                req.newBuilder().method(trans.getMethod().text, null);
            }
            com.squareup.okhttp.Response res = client.newCall(req).execute();
            Object responsePayload = Helper.MAPPER.readValue(res.body().byteStream(), Object.class);
            if (res.isSuccessful()) {
                Object resBody = Helper.MAPPER.convertValue(responsePayload, bodyClass);
                Response<Object> clientRes = new Response<Object>(res.code(), !res.isSuccessful(), resBody);
                return clientRes;
            }
            HashMap rBody = (HashMap)Helper.MAPPER.convertValue(responsePayload, HashMap.class);
            errObj = (StrapiError)Helper.MAPPER.convertValue(rBody.get("error"), StrapiError.class);
            throw new CustomException(errObj.getMessage(), errObj.getStatus(), errObj.getDetails());
        }
        catch (CustomException ce) {
            throw ce;
        }
        catch (IOException | IllegalArgumentException ex) {
            errObj.setMessage(ex.getMessage());
            Logger.getLogger(Connector.class.getName()).log(Level.SEVERE, null, ex);
            return new Response<Object>(errObj.getMessage(), errObj.getStatus(), Boolean.TRUE, null);
        }
    }
}

