/*
 * Decompiled with CFR 0.152.
 */
package org.vfd.strapi;

import org.vfd.strapi.Connector;
import org.vfd.strapi.Transporter;
import org.vfd.strapi.enums.HttpMethod;
import org.vfd.strapi.enums.ResponseMessage;
import org.vfd.strapi.interfaces.SingularInterface;
import org.vfd.strapi.models.Response;
import org.vfd.strapi.models.StrapiMonoResponse;

public class Singular
implements SingularInterface {
    private final Transporter config;

    public Singular(Transporter config) {
        this.config = config;
    }

    @Override
    public <T> Response<StrapiMonoResponse<T>> get(String singularApiId, Class<T> rClass, String ... rawQuery) {
        this.config.setCurrentEndpoint(singularApiId);
        this.config.setMethod(HttpMethod.GET);
        this.config.setSorting(null);
        this.config.setPagination(null);
        this.config.setRawQuery(rawQuery);
        Response<StrapiMonoResponse<T>> res = Connector.connect(this.config, StrapiMonoResponse.class);
        if (!res.getHasError().booleanValue()) {
            res.setMessage(ResponseMessage.DATA_FETCHED.text);
        }
        return res;
    }

    @Override
    public <T> Response<StrapiMonoResponse<T>> update(String singularApiId, T payload, Class<T> rClass, String ... rawQuery) {
        this.config.setCurrentEndpoint(singularApiId);
        this.config.setMethod(HttpMethod.PUT);
        this.config.setPayload(payload);
        this.config.setSorting(null);
        this.config.setPagination(null);
        this.config.setRawQuery(rawQuery);
        Response<StrapiMonoResponse<T>> res = Connector.connect(this.config, StrapiMonoResponse.class);
        if (!res.getHasError().booleanValue()) {
            res.setMessage(ResponseMessage.UPDATED.text);
        }
        return res;
    }

    @Override
    public <T> Response<StrapiMonoResponse<T>> delete(String singularApiId, Class<T> rClass, String ... rawQuery) {
        this.config.setCurrentEndpoint(singularApiId);
        this.config.setMethod(HttpMethod.DELETE);
        this.config.setSorting(null);
        this.config.setPagination(null);
        this.config.setRawQuery(rawQuery);
        Response<StrapiMonoResponse<T>> res = Connector.connect(this.config, StrapiMonoResponse.class);
        if (!res.getHasError().booleanValue()) {
            res.setMessage(ResponseMessage.DELETE.text);
        }
        return res;
    }
}

