/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5;

import io.bootique.BQModuleProvider;
import io.bootique.BQRuntime;
import io.bootique.junit5.BQTestFactory;
import io.bootique.junit5.BQTestScope;
import io.bootique.meta.module.ModuleMetadata;
import io.bootique.meta.module.ModulesMetadata;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExecutableInvoker;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Deprecated(since="3.0", forRemoval=true)
public class BQModuleProviderChecker {
    private Class<? extends BQModuleProvider> provider;

    protected BQModuleProviderChecker(Class<? extends BQModuleProvider> provider) {
        this.provider = Objects.requireNonNull(provider);
    }

    public static void testAutoLoadable(Class<? extends BQModuleProvider> provider) {
        new BQModuleProviderChecker(provider).testAutoLoadable();
    }

    public static void testMetadata(Class<? extends BQModuleProvider> provider) {
        new BQModuleProviderChecker(provider).testMetadata();
    }

    protected Stream<BQModuleProvider> matchingProviders() {
        return StreamSupport.stream(ServiceLoader.load(BQModuleProvider.class).spliterator(), false).filter(p -> p != null && this.provider.equals(p.getClass()));
    }

    protected BQModuleProvider matchingProvider() {
        return this.matchingProviders().findFirst().get();
    }

    protected void testAutoLoadable() {
        long c = this.matchingProviders().count();
        switch ((int)c) {
            case 0: {
                Assertions.fail((String)("Expected provider '" + this.provider.getName() + "' is not found"));
                break;
            }
            case 1: {
                break;
            }
            default: {
                Assertions.fail((String)("Expected provider '" + this.provider.getName() + "' is found more then once: " + c));
            }
        }
    }

    protected void testMetadata() {
        try {
            this.testWithFactory(testFactory -> {
                BQRuntime runtime = testFactory.app(new String[0]).autoLoadModules().createRuntime();
                String providerName = this.matchingProvider().name();
                Optional<ModuleMetadata> moduleMetadata = ((ModulesMetadata)runtime.getInstance(ModulesMetadata.class)).getModules().stream().filter(mmd -> providerName.equals(mmd.getProviderName())).findFirst();
                Assertions.assertTrue((boolean)moduleMetadata.isPresent(), (String)("No module metadata available for provider: '" + providerName + "'"));
                moduleMetadata.get().getConfigs();
            });
        }
        catch (Exception e) {
            Assertions.fail((String)"Metadata test failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testWithFactory(Consumer<BQTestFactory> test) {
        BQTestFactory testFactory = new BQTestFactory();
        TestExtensionContext extensionContext = new TestExtensionContext();
        try {
            testFactory.beforeScope(BQTestScope.TEST_METHOD, extensionContext);
            test.accept(testFactory);
        }
        finally {
            testFactory.afterScope(BQTestScope.TEST_METHOD, extensionContext);
        }
    }

    private static class TestExtensionContext
    implements ExtensionContext {
        private TestExtensionContext() {
        }

        public Optional<ExtensionContext> getParent() {
            return Optional.empty();
        }

        public ExtensionContext getRoot() {
            return null;
        }

        public String getUniqueId() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public Set<String> getTags() {
            return null;
        }

        public Optional<AnnotatedElement> getElement() {
            return Optional.empty();
        }

        public Optional<Class<?>> getTestClass() {
            return Optional.empty();
        }

        public Optional<TestInstance.Lifecycle> getTestInstanceLifecycle() {
            return Optional.empty();
        }

        public Optional<Object> getTestInstance() {
            return Optional.empty();
        }

        public Optional<TestInstances> getTestInstances() {
            return Optional.empty();
        }

        public Optional<Method> getTestMethod() {
            return Optional.empty();
        }

        public Optional<Throwable> getExecutionException() {
            return Optional.empty();
        }

        public Optional<String> getConfigurationParameter(String s) {
            return Optional.empty();
        }

        public ExecutableInvoker getExecutableInvoker() {
            return null;
        }

        public void publishReportEntry(Map<String, String> map) {
        }

        public ExtensionContext.Store getStore(ExtensionContext.Namespace namespace) {
            return null;
        }

        public <T> Optional<T> getConfigurationParameter(String key, Function<String, T> transformer) {
            return Optional.empty();
        }

        public ExecutionMode getExecutionMode() {
            return ExecutionMode.SAME_THREAD;
        }
    }
}

