/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5;

import io.bootique.BQModule;
import io.bootique.BQRuntime;
import io.bootique.Bootique;
import io.bootique.meta.module.ModuleMetadata;
import io.bootique.meta.module.ModulesMetadata;
import java.util.Optional;
import java.util.ServiceLoader;
import org.junit.jupiter.api.Assertions;

public class BQModuleTester {
    private final Class<? extends BQModule> moduleType;
    private volatile Integer autoLoadCount;

    public static BQModuleTester of(Class<? extends BQModule> moduleType) {
        return new BQModuleTester(moduleType);
    }

    protected BQModuleTester(Class<? extends BQModule> moduleType) {
        this.moduleType = moduleType;
    }

    public BQModuleTester testAutoLoadable() {
        int c = this.autoLoadCount();
        switch (c) {
            case 0: {
                Assertions.fail((String)("Module of type '" + this.moduleType.getName() + "' is not auto-loadable. To make it auto-loadable, add it to 'META-INF/services/io.bootique.BQModule' file on classpath"));
                break;
            }
            case 1: {
                break;
            }
            default: {
                Assertions.fail((String)("Auto-loadable module of type '" + this.moduleType.getName() + "' is found more then once: " + c));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BQModuleTester testConfig() {
        BQRuntime runtime;
        boolean autoLoadable = this.autoLoadCount() > 0;
        try {
            runtime = autoLoadable ? Bootique.app((String[])new String[0]).autoLoadModules().createRuntime() : Bootique.app((String[])new String[0]).module(this.moduleType).createRuntime();
        }
        catch (Exception e) {
            Assertions.fail((String)"Auto-loading test runtime creation failed", (Throwable)e);
            return this;
        }
        try {
            Optional<ModuleMetadata> moduleMetadata = ((ModulesMetadata)runtime.getInstance(ModulesMetadata.class)).getModules().stream().filter(mmd -> this.moduleType == mmd.getType()).findFirst();
            Assertions.assertTrue((boolean)moduleMetadata.isPresent(), () -> "No metadata available for Module: '" + this.moduleType.getName() + "'");
            moduleMetadata.get().getConfigs();
        }
        catch (Exception e) {
            Assertions.fail((String)"Could not resolve metadata", (Throwable)e);
        }
        finally {
            runtime.shutdown();
        }
        return this;
    }

    private int autoLoadCount() {
        if (this.autoLoadCount == null) {
            this.autoLoadCount = (int)ServiceLoader.load(BQModule.class).stream().filter(p -> this.moduleType == p.type()).count();
        }
        return this.autoLoadCount;
    }
}

