/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.junit5;

import io.bootique.BQModule;
import io.bootique.BQRuntime;
import io.bootique.meta.module.ModuleMetadata;
import io.bootique.meta.module.ModulesMetadata;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;

public class BQRuntimeChecker {
    @SafeVarargs
    public static void testModulesLoaded(BQRuntime runtime, Class<? extends BQModule> ... expectedModules) {
        ModulesMetadata modulesMetadata = (ModulesMetadata)runtime.getInstance(ModulesMetadata.class);
        Set actualModules = modulesMetadata.getModules().stream().map(ModuleMetadata::getName).collect(Collectors.toSet());
        List missingModules = Stream.of(expectedModules).map(Class::getSimpleName).filter(n -> !actualModules.contains(n)).collect(Collectors.toList());
        if (!missingModules.isEmpty()) {
            Assertions.fail((String)("The following expected modules are missing: " + missingModules));
        }
    }
}

